# Copyright (C)2003..2025 @BABOLO http://www.babolo.ru/
# PKG = babolo-libmake
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: define.make,v 1.53 2025/03/21 02:23:00 babolo Exp $

.MAIN: all
.SUFFIXES: .sql .4tml .html .shtml .so .so.${MAJOR} .cgm4 .cgi .m4 .la .lo .lexor .h
.PHONY: doman gitup notify protover todo version                            \
        subdir subdirinstall supdir supdirinstall ignore findiff            \
        all preall doall postall objnlib                                    \
        install preinstall doinstall postinstall                            \
        tarball pretarball dotarball posttarball                            \
        clean preclean doclean postclean cleacvs                            \
        release prerelease dorelease postrelease delrelease rerelease dotag

PROTARGETS	?= all install doman subdir supdir objnlib                                            \
                   doall doinstall postall postinstall preall preinstall subdirinstall supdirinstall
ANTARGETS	?= gitup notify version todo ignore findiff cleacvs                                   \
                   cleacvs clean delrelease release rerelease tarball                                 \
                   postclean postrelease posttarball preclean prerelease pretarball                   \
                   doclean dorelease dotag dotarball

PREFIX		?= /usr/local
INCLUDEDIR	?= ${PREFIX}/include
LIBINCLUDEDIR	?= ${INCLUDEDIR}/babolo

.include <${LIBINCLUDEDIR}/param.make>

BINMODE		?= 0555
MANMODE		?= 0444
DATAMODE	?= 0444
#OWNER		?= -o root -g wheel
CHOWNER 	?= "0:0"
INSTALL_PROGRAM	?= install -c -s ${OWNER} -m ${BINMODE}
INSTALL_SCRIPT	?= install -C ${OWNER} -m ${BINMODE}
INSTALL_DATA	?= install -C ${OWNER} -m ${DATAMODE}
INSTALL_MAN	?= install -C ${OWNER} -m ${MANMODE}
BINDIR		?= ${PREFIX}/bin
LIBIDIR		?= ${PREFIX}/lib
CONFDIR		?= ${PREFIX}/etc
LIBODIR		?= ${LIBIDIR}
MAN1DIR		?= ${PREFIX}/man/${MANLANG}/man1
MAN3DIR		?= ${PREFIX}/man/${MANLANG}/man3
MAN5DIR		?= ${PREFIX}/man/${MANLANG}/man5
MAN8DIR		?= ${PREFIX}/man/${MANLANG}/man8
LIBEDIR		?= ${PREFIX}/libexec/${PKG}
BUILDINCLUDEDIR	?= ${LIBINCLUDEDIR}
FORINCLUDEDIR	?= ${INCLUDEDIR}
VERSIONDIR	?= ${LIBINCLUDEDIR}
WWWROOT		?= ${PREFIX}/www
CGIDIR		?= ${WWWROOT}/bin
BABOLOMAKE_CONF	?= ${PREFIX}/etc/babolomake.conf
AR		?= ar
CP		?= cp
MV		?= mv
RM		?= rm
SH		?= sh
LN		?= ln
CAT		?= cat
SED		?= sed
AWK		?= awk
SCP		?= scp
CVS		?= cvs
MD5		?= md5
PLUSENV		?= env
TAR		?= tar
PWD		?= pwd
GZIP		?= gzip
GREP		?= grep
ECHO		?= echo
FIND		?= find
HEAD		?= head
TRUE		?= true
GETDATE		?= date
MKDIR		?= mkdir
CHOWN		?= chown
CHMOD		?= chmod
FALSE		?= false
TOOLS		?= tools
SHA256		?= sha256
RANLIB		?= ranlib
PG_CONFIG	?= pg_config
CONFIGCONF	?= babololib_configconf
EXECTMPL	?= ${PLUSENV} ECHO=${ECHO} CAT=${CAT} SED=${SED} GREP=${GREP} SH=${SH} ${SH} -e
PG_INCLDIR_SRV	!= if ${PG_CONFIG} --includedir-server 2>/dev/null; then ${TRUE}; fi
PG_MODULEDIR	!= if ${PG_CONFIG} --pkglibdir 2>/dev/null; then ${TRUE}; fi
PG_SQLIBDIR	?= ${PREFIX}/share/postgresql/contrib
MAXWARN 	?= 1

.if defined(BLINUX) || defined(BLIN_OSLinux)
  MAKEFLAGS	+= ${BLINUX} -DBLIN_OSLinux MAKE=bmake M4=m4
  M4		?= m4
  MAKE		?= bmake
  LDCONFIG	?= /usr/sbin/ldconfig
.else
  M4		?= gm4
  MAKE		?= make
  LDCONFIG	?= /sbin/ldconfig
.endif

.if defined(BASE)
. if defined(MODULE)
   LIBEDIR	?= ${PREFIX}/libexec/${BASE}/${MODULE}${SUBMODULE}
. else
   LIBEDIR	?= ${PREFIX}/libexec/${BASE}
. endif
  DATADIR	?= ${LIBEDIR}
  GENCLASS	?= ${MODULE}
  PKG		?= ${BASE}-${MODULE}${SUBMODULE}
.endif

.if defined(VMINOR)
  VERS	= ${VMAJOR}.${VMINOR}
  DISTNM= ${PKG}-${VERS}
. if !defined(DATE)
.  if defined(BLIN_OSLinux)
    DATE	!= ${PLUSENV} LANG= LC_ALL= ${GETDATE} -I
.  else
    DATE	!= ${PLUSENV} LANG= LC_ALL= ${GETDATE} +%v | sed -e 's| ||g'
.  endif
. endif
.endif

.if !defined(PG_INCLDIR_SRV) || ${PG_INCLDIR_SRV} == ""
  PG_INCLDIR_SRV=${POSTGRESRC}/src/include
.endif

.if !defined(PG_MODULEDIR) || ${PG_MODULEDIR} == ""
  PG_MODULEDIR	=${LIBODIR}/postgresql
.endif

.if defined(DESTDIR)
MAKEFLAGS	+= DESTDIR=${DESTDIR}
.endif

CFLAGS		+= ${CFLAGSPLUS} -DPREFIX=\"${PREFIX}\"
CFLAGS		+= -DVMAJOR=${VMAJOR} -DVERS=\"${VERS}\" -DDATE=\"${DATE}\"
LDFLAGS 	+= ${LDFLAGSPLUS}
MAKEFLAGS	+= -m /usr/share/mk
MAKEFLAGS	+= -m ${BUILDINCLUDEDIR} BUILDINCLUDEDIR=${BUILDINCLUDEDIR}
MAKEFLAGS	+= -m ${LIBINCLUDEDIR} LIBINCLUDEDIR=${LIBINCLUDEDIR}
M4FLAGS		+= -DLIBINCLUDEDIR=${LIBINCLUDEDIR} -DBUILDINCLUDEDIR=${BUILDINCLUDEDIR}
M4INC		+= ${LIBINCLUDEDIR}/def.m4
MAKEINC		+= ${LIBINCLUDEDIR}/define.make ${LIBINCLUDEDIR}/common.make Makefile

MISC		+= Makefile
DIST		+= ${SRCS} ${MANS1} ${MANS3} ${MANS5} ${MANS8} ${MISC} ${SQLS} ${CONF}
CLEAN		+= Prot_O_Version ${CONG}

.if defined(MACHINE_CPU)
. if (${MACHINE_CPU} == i386)
   FPIC	= pic
. else # amd64
   FPIC	= PIC
. endif
.endif

.if defined(MACHINE_ARCH)
. if (${MACHINE_ARCH} == i386)
   FPIC	= pic
. else # amd64
   FPIC	= PIC
. endif
.endif

.if "${PKG}" != "${PKG:C/[^-a-zA-Z0-9_.]//W}"
. error Illegal PKG="${PKG}"
.endif

.if "${VMINOR}" != "${VMINOR:C/[^0-9]//W}"
. error Illegal VMINOR="${VMINOR}"
.endif

.if target(protover)
. ifdef(PROTOVER)
.  if "x${PROTOVER}" == "x"
.   error Empty PROTOVER
.  endif
.  if exists(Prot_O_Version)
    PROTOVERTEST	!= cat Prot_O_Version
.   if "x${PROTOVER}" != "x${PROTOVERTEST}"
.    error PROTOVER "${PROTOVER}" <> "${PROTOVERTEST}"
.   endif
.  endif
. else
.  if exists(Prot_O_Version)
    PROTOVER	!= cat Prot_O_Version
.   if "x${PROTOVER}" == "x"
.    error Empty PROTOVER
.   endif
.  else
.   ifmake subdir || supdir || supdirinstall || subdirinstall    \
        || all || doall || preall || postall || objnlib || doman \
        || install || doinstall || preinstall || postinstall
.    error PROTOVER not defined
.   endif
.  endif
. endif
.endif

.for I in ${LEXORL}
  LEXORH	+= ${I}.h
  CLEAN		+= ${I}.h
  MISC		+= ${I}.lexor
.endfor

.if defined(PROG)
  CLEAN		+= ${PROG}
. for I in ${PROG}
    SRCS	+= ${I}.c
. endfor
.endif

.for I in ${INCS}
  INCH		+= ${I}.h
.endfor
INCI		?= ${INCH}

.if defined(PGMOD)
. for I in ${PGMOD}
   DATA		+= ${I}.so.${VMAJOR}
   SRCS		+= ${I}.c
   CLEAN	+= ${I}.so.${VMAJOR}
. endfor
.endif

.for I in ${CSRC}
  SRCS		+= ${I}.c
  OBJS		+= ${I}.o
  CLEAN		+= ${I}.o
.endfor

.if defined(SHLIB)
. if defined(LIBNAME)
   DOSHLIB	= ${LIBNAME}
. else
   DOSHLIB	= ${PKG}
. endif
   SHLIBNAME	= lib${DOSHLIB}.so
   SHLIBVNAME	= ${SHLIBNAME}.${VMAJOR}
   CLEAN	+= ${SHLIBVNAME} ${SHLIBNAME}
.endif

.if defined(STLIB)
. if defined(LIBNAME)
   DOSTLIB	+= ${LIBNAME}
. else
   DOSTLIB	+= ${PKG}
. endif
   STLIBNAME	= lib${DOSTLIB}.a
   CLEAN	+= ${STLIBNAME}
.endif

.if defined(SGEN)
  MGEN		+= ${SGEN}
  SCRIPTS	+= ${SGEN}
.endif

.if defined(MGEN)
  CLEAN		+= ${MGEN}
. for I in ${MGEN}
   DIST		+= ${I}.m4
. endfor
.endif

.if defined(CGM4)
  BINOVER	?= ${CGIDIR}/${PKG}
. for I in ${CGM4}
   SCRIPTS	+= ${I}.cgi
   CLEAN	+= ${I}.cgi
   DIST		+= ${I}.cgm4
. endfor
.endif

.if defined(TITLE)
  CLEAN		+= index.4tml index.dir
.endif

.for I in ${MAN} ${PROG} ${SCRIPTS} ${PKG}
. if exists(${I}.1)
   MANS1	+= ${I}.1
. endif
. if exists(${I}.3)
   MANS3	+= ${I}.3
. endif
. if exists(${I}.5)
   MANS5	+= ${I}.5
. endif
. if exists(${I}.8)
   MANS8	+= ${I}.8
. endif
.endfor

.for I in ${MANS1}
  DIST	+= ${I}
  MANZ1	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor
.for I in ${MANS3}
  DIST	+= ${I}
  MANZ3	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor
.for I in ${MANS5}
  DIST	+= ${I}
  MANZ5	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor
.for I in ${MANS8}
  DIST	+= ${I}
  MANZ8	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor

.if defined(SCRIPTFILTER)
. if defined(CONFDIR)
   SCRIPTFILTER	+= -e 's|%%CONFDIR%%|${CONFDIR}|g'
. endif
. if defined(LIBEDIR)
   SCRIPTFILTER	+= -e 's|%%LIBEDIR%%|${LIBEDIR}|g'
. endif
. if defined(BINDIR)
   SCRIPTFILTER	+= -e 's|%%BINDIR%%|${BINDIR}|g'
. endif
. if defined(PREFIX)
   SCRIPTFILTER	+= -e 's|%%PREFIX%%|${PREFIX}|g'
. endif
. if defined(WWWROOT)
   SCRIPTFILTER	+= -e 's|%%WWWROOT%%|${WWWROOT}|g'
. endif
. if defined(WWWROOTDATA)
   SCRIPTFILTER	+= -e 's|%%WWWROOTDATA%%|${WWWROOTDATA}|g'
. endif
.endif

CLANG		!= if ${CC} -v 2>&1 | ${GREP} -q clang ; then echo clang; fi
.if (${CLANG} == clang)
  CFLAGSPLUS	+= -Wno-invalid-source-encoding
.endif

.if exists(${BABOLOMAKE_CONF})
. include <${BABOLOMAKE_CONF}>
. if defined(USERMAKE_CONF)
.  if exists(${USERMAKE_CONF})
.   include <${USERMAKE_CONF}>
.  endif
. endif
.endif
