/*-
 * Copyright (C)2014..2023 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2023 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: test1.c,v 1.2 2023/12/02 11:54:23 babolo Exp $"

#define BLIN_COMPAT VMAJOR

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include "../BLINflag.h"

static const char * const
fac[] =
{ "KERN"  , "USER"  , "MAIL"    , "DAEMON", "AUTH"  , "SYSLOG"  , "LPR"    , "NEWS"
, "UUCP"  , "CRON"  , "AUTHPRIV", "FTP"   , "NTP"   , "SECURITY", "CONSOLE", NULL
, "LOCAL0", "LOCAL1", "LOCAL2"  , "LOCAL3", "LOCAL4", "LOCAL5"  , "LOCAL6" , "LOCAL7"
};

static const char * const
whatf[] = 
{ NULL     , NULL     , NULL     , NULL  , "MODDTXT", NULL     , NULL     , NULL
, NULL     , NULL     , NULL     , NULL  , "MODDSTR", "MODDNON", "MODDREL", "MODTIME"
, "MODEOLF", "MODEOCR", "MODEOAU", NULL  , NULL     , "MODLOGR", "MODPRNT", "MODWARN"
, "LOCAL0", "LOCAL1", "LOCAL2"  , "LOCAL3", "LOCAL4", "LOCAL5"  , "LOCAL6" , "LOCAL7"
};

static const char * const
maskn[] =
{ "mtime", "ctime", "btime", "lock"
, "atime", "point", "owner", "group"
, "mode" , NULL   , NULL   , NULL
, NULL   , NULL   , NULL   , "NOrm"
};

static const char * const
pg[] =
{ "ISIN"    , NULL      , "CTL"     , NULL      ,  "OUTSET" , "CONNECT" , "JOB"    , "STYLE"
, "EXTENDED", NULL      , NULL      , "FORKED"  ,  "TRAPDEF", "STYLEN"  , "END"    , "ERROR"
, "FREEPATH", "FREETEXT", "FREEMIFE", "FREEPQRE",  "LEXLVUP", "LEXLDOWN", "NOLITER", "IGNORE"
};

int
main(int argc, char **argv) {
    (void)argc;
    (void)argv;
    printf("=%d\n", blin_64(0xFFFF, maskn, 16, stdout));
    printf("=%d\n", blin_64(0x0000, maskn, 16, stdout));
    printf("=%d\n", blin_64(0xAAAA, maskn, 16, stdout));
    printf("=%d\n", blin_64(0x5555, maskn, 16, stdout));
    printf("=%d\n", blin_64(0x0033, maskn, 16, stdout));
    printf("=%d\n", blin_64(0x81FF, maskn, 16, stdout));
    printf("=%d\n", blin_64(0xFFFF, maskn, -16, stdout));
    printf("=%d\n", blin_64(0x0000, maskn, -16, stdout));
    printf("=%d\n", blin_64(0xAAAA, maskn, -16, stdout));
    printf("=%d\n", blin_64(0x5555, maskn, -16, stdout));
    printf("=%d\n", blin_64(0x3300, maskn, -16, stdout));
    printf("=%d\n", blin_64(0xFF81, maskn, -16, stdout));
    printf("=%d\n", blin_64(0xF, maskn, 4, stdout));
    printf("=%d\n", blin_64(0x0, maskn, 4, stdout));
    printf("=%d\n", blin_64(0xA, maskn, 4, stdout));
    printf("=%d\n", blin_64(0x5, maskn, 4, stdout));
    printf("=%d\n", blin_64(0x3, maskn, 4, stdout));
    printf("=%d\n", blin_64(0x8, maskn, 4, stdout));
    printf("=%d\n", blin_64(0xF, maskn, -4, stdout));
    printf("=%d\n", blin_64(0x0, maskn, -4, stdout));
    printf("=%d\n", blin_64(0xA, maskn, -4, stdout));
    printf("=%d\n", blin_64(0x5, maskn, -4, stdout));
    printf("=%d\n", blin_64(0x3, maskn, -4, stdout));
    printf("=%d\n", blin_64(0x8, maskn, -4, stdout));
    printf("=%d\n", blin_64(0xFFFFFF, fac, 24, stdout));
    printf("=%d\n", blin_64(0x000000, fac, 24, stdout));
    printf("=%d\n", blin_64(0xAAAAAA, fac, 24, stdout));
    printf("=%d\n", blin_64(0x555555, fac, 24, stdout));
    printf("=%d\n", blin_64(0x330033, fac, 24, stdout));
    printf("=%d\n", blin_64(0xFFFFFF00, fac, -24, stdout));
    printf("=%d\n", blin_64(0x00000000, fac, -24, stdout));
    printf("=%d\n", blin_64(0xAAAAAA00, fac, -24, stdout));
    printf("=%d\n", blin_64(0x55555500, fac, -24, stdout));
    printf("=%d\n", blin_64(0xCC00CC00, fac, -24, stdout));
    printf("=%d\n", blin_64(0xFFFFFFFF, whatf, 32, stdout));
    printf("=%d\n", blin_64(0x00000000, whatf, 32, stdout));
    printf("=%d\n", blin_64(0xAAAAAAAA, whatf, 32, stdout));
    printf("=%d\n", blin_64(0x55555555, whatf, 32, stdout));
    printf("=%d\n", blin_64(0x00330033, whatf, 32, stdout));
    printf("=%d\n", blin_64(0x33230000, whatf, 32, stdout));
    printf("=%d\n", blin_64(0xFFE7F010, whatf, 32, stdout));
    printf("=%d\n", blin_64(0x0FFF, maskn, 12, stdout));
    printf("=%d\n", blin_64(0x0000, maskn, 12, stdout));
    printf("=%d\n", blin_64(0x0AAA, maskn, 12, stdout));
    printf("=%d\n", blin_64(0x0555, maskn, 12, stdout));
    printf("=%d\n", blin_64(0x0033, maskn, 12, stdout));
    printf("=%d\n", blin_64(0xFFF9F5, pg, 24, stdout));
    printf("=%d\n", blin_64(0xAAA9D5, pg, 24, stdout));
    printf("=%d\n", blin_64(0x5559F5, pg, 24, stdout));
    printf("=%d\n", blin_64(0xF5, pg, 8, stdout));
    printf("=%d\n", blin_64(0xFF, pg, 8, stdout));
    printf("=%d\n", blin_64(0x55, pg, 8, stdout));
    printf("=%d\n", blin_64(0xAA, pg, 8, stdout));
    printf("=%d\n", blin_64(0xAF, pg, -8, stdout));
    exit(0);
}
