/*-
 * Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/
 * Portions Copyright (c) 2000, PostgreSQL Global Development Group
 * PKG = babolo_pglib
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2002..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) Portions Copyright (c) 2000, PostgreSQL Global Development Group"
#ident "@(#) $Id: pglib_bytea.c,v 1.14 2025/11/12 02:39:09 babolo Exp $"

#include <sys/types.h>
#include <postgres.h>
#include <fmgr.h>
#include <utils/inet.h>
#include <nodes/nodes.h>
#include <nodes/execnodes.h>

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

PG_FUNCTION_INFO_V1(bytea_int8);
Datum
bytea_int8(PG_FUNCTION_ARGS) {
    u_int64_t res = 0;
    u_char   *c;
    text     *a;
    size_t    l;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    a = PG_GETARG_TEXT_PP(0);
    c = (u_char*)VARDATA_ANY(a);
    l = VARSIZE_ANY_EXHDR(a);
    if  (l > 8) l = 8;
    for (u_int i = 0; i < l; i++) {
        res |= (u_int64_t)(*(c++) & 0xFF) << (8 * i);
    }
    PG_FREE_IF_COPY(a, 0);
    PG_RETURN_INT64((int64)res);
}

PG_FUNCTION_INFO_V1(int4_bytea);
Datum
int4_bytea(PG_FUNCTION_ARGS) {
    text *result;
    char *cp;
    int   len;
    int   in;
    int   i;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    in = PG_GETARG_INT32(0);
    len = PG_GETARG_INT32(1);
    if  (!(result = (text*)palloc((Size)(len + VARHDRSZ)))) {
        ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("int4_bytea: out of memory")));
    }
#ifdef VARATT_SIZEP
    VARATT_SIZEP(result) = len + VARHDRSZ;
#else
    SET_VARSIZE(result, len + VARHDRSZ);
#endif
    cp = VARDATA(result);
    for (i = 0; i < len; i++) {
        *cp++ = in & 0xFF;
        in = in >> 8;
    }
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(int8_bytea);
Datum
int8_bytea(PG_FUNCTION_ARGS) {
    text     *result;
    char     *cp;
    int       len;
    u_int64_t in;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    in = (u_int64_t)PG_GETARG_INT64(0);
    len = PG_GETARG_INT32(1);
    if  (!(result = (text*)palloc((Size)(len + VARHDRSZ)))) {
        ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("int8_bytea: out of memory")));
    }
#ifdef VARATT_SIZEP
    VARATT_SIZEP(result) = len + VARHDRSZ;
#else
    SET_VARSIZE(result, len + VARHDRSZ);
#endif
    cp = VARDATA(result);
    for (int i = 0; i < len; i++) {
        *(cp++) = (char)(in & 0xFF);
        in = in >> 8;
    }
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(text_bytea);
Datum
text_bytea(PG_FUNCTION_ARGS) {
    text *t;
    text *result;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    t = PG_GETARG_TEXT_P(0);
    if  (!(result = (text*)palloc(VARSIZE(t)))) {
        ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("text_bytea: out of memory")));
    }
    memcpy(result, t, VARSIZE(t));
    PG_FREE_IF_COPY(t, 0);
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(bytea_text);
Datum
bytea_text(PG_FUNCTION_ARGS) {
    text *t;
    text *result;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    t = PG_GETARG_BYTEA_P(0);
    if  (!(result = (text*)palloc(VARSIZE(t)))) {
        ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("bytea_text: out of memory")));
    }
    memcpy(result, t, VARSIZE(t));
    PG_FREE_IF_COPY(t, 0);
    PG_RETURN_TEXT_P(result);
}

PG_FUNCTION_INFO_V1(bytearradd);
Datum
bytearradd(PG_FUNCTION_ARGS) {
    text   *result;
    int     swap;
    u_char *c0;
    u_char *c1;
    u_char *cr;
    text   *a0;
    text   *a1;
    size_t  l0;
    size_t  l1;
    size_t  l;
    int     k;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    a0 = PG_GETARG_BYTEA_PP(0);
    a1 = PG_GETARG_BYTEA_PP(1);
    l0 = VARSIZE_ANY_EXHDR(a0);
    l1 = VARSIZE_ANY_EXHDR(a1);
    swap = 0;
    if  (l0 > l1) { /*  ,    l0 <= l1 */
        l0 ^= l1;
        l1 ^= l0;
        l0 ^= l1;
        swap = 1;
    }
    if  (!(result = (text*)palloc(l1 + VARHDRSZ))) {
        ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("bytearradd: out of memory")));
    }
#ifdef SET_VARSIZE
    SET_VARSIZE(result, l1 + VARHDRSZ);
#else
    VARATT_SIZEP(result) = l1 + VARHDRSZ;
#endif
    c0 = (u_char*)VARDATA_ANY(swap ? a1 : a0);
    c1 = (u_char*)VARDATA_ANY(swap ? a0 : a1);
    cr = (u_char*)VARDATA(result);
    for (l = 0; l < l0; ++l) {
        k = *(c0++) + *(c1++);
        *(cr++) = (k > 255) ? 255 : (u_char)k;
    }
    for (; l < l1; ++l) {
        *(cr++) = *(c1++);
    }
    PG_FREE_IF_COPY(a1, 1);
    PG_FREE_IF_COPY(a0, 0);
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(bytearrmax);
Datum
bytearrmax(PG_FUNCTION_ARGS) {
    size_t  l0;
    u_char *c0;
    text   *a0;
    size_t  l;
    u_int   k;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    a0 = PG_GETARG_BYTEA_PP(0);
    l0 = VARSIZE_ANY_EXHDR(a0);
    c0 = (u_char*)VARDATA_ANY(a0);
    for (l = 0, k = 0; l < l0; ++l, ++c0) {
        if  (k < *c0) k = *c0;
    }
    PG_FREE_IF_COPY(a0, 0);
    PG_RETURN_INT32((int32)k);
}
