/*-
 * Copyright (C)2023..2025 @BABOLO http://www.babolo.ru/
 * Portions Copyright (c) 2000, PostgreSQL Global Development Group
 * PKG = babolo_pglib
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2025 @BABOLO http://www.babolo.ru/"
#ident "@(#) Portions Copyright (c) 1996-2018, PostgreSQL Global Development Group"
#ident "@(#) Portions Copyright (c) 1994, Regents of the University of California"
#ident "@(#) $Id: pglib_geo.c,v 1.5 2025/11/12 02:39:09 babolo Exp $"


#include <sys/types.h>
#include <postgres.h>
#include <fmgr.h>
#include <utils/geo_decls.h>
#include <nodes/nodes.h>
#include <nodes/execnodes.h>

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

PG_FUNCTION_INFO_V1(lseg_path);
Datum
lseg_path(PG_FUNCTION_ARGS) {
    LSEG *lseg  = PG_GETARG_LSEG_P(0);
    PATH *path;
    int   npts  = 2;
    int   base  = (int)sizeof(path->p[0]) * npts;
    int   size  = (int)offsetof(PATH, p) + base;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    if  (base / npts != sizeof(path->p[0]) || size <= base) {
        ereport( ERROR
               , ( errcode(ERRCODE_PROGRAM_LIMIT_EXCEEDED)
                 , errmsg("too many points requested %d <> %d", base / npts, (int)sizeof(path->p[0]))
               ) );
    }
    path = (PATH*)palloc((Size)size);
    SET_VARSIZE(path, size);
    path->npts = npts;
    path->closed = 0;
    path->p[0].x = lseg->p[0].x;
    path->p[0].y = lseg->p[0].y;
    path->p[1].x = lseg->p[1].x;
    path->p[1].y = lseg->p[1].y;
    path->dummy = 0;
    PG_RETURN_PATH_P(path);
}

PG_FUNCTION_INFO_V1(path_expand);
Datum
path_expand(PG_FUNCTION_ARGS) {
    PATH  *path = PG_GETARG_PATH_P(0);
    Point *pt   = PG_GETARG_POINT_P(1);
    PATH  *res;
    int    npts = path->npts;
    int    base = (int)sizeof(path->p[0]) * (npts + 1);
    int    size = (int)offsetof(PATH, p) + base;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    if  (base / (npts + 1) != sizeof(path->p[0]) || size <= base) {
        ereport( ERROR
               , ( errcode(ERRCODE_PROGRAM_LIMIT_EXCEEDED)
                 , errmsg("too many points requested")
               ) );
    }
    res = (PATH*)palloc((Size)size);
    SET_VARSIZE(res, size);
    res->npts = npts + 1;
    res->closed = 0;
    for (int i = 0; i < npts; ++i) {
        res->p[i].x = path->p[i].x;
        res->p[i].y = path->p[i].y;
    }
    res->p[npts].x = pt->x;
    res->p[npts].y = pt->y;
    res->dummy = 0;
    PG_FREE_IF_COPY(path, 0);
    PG_RETURN_PATH_P(res);
}

PG_FUNCTION_INFO_V1(path_link);
Datum
path_link(PG_FUNCTION_ARGS) {
    PATH *path = PG_GETARG_PATH_P(0);
    LSEG *lseg;

    if  (PG_ARGISNULL(0) || (path->npts < 1)) PG_RETURN_NULL();
    lseg = (LSEG*)palloc(sizeof(LSEG));
    lseg->p[0].x = path->p[0].x;
    lseg->p[0].y = path->p[0].y;
    lseg->p[1].x = path->p[path->npts - 1].x;
    lseg->p[1].y = path->p[path->npts - 1].y;
    PG_FREE_IF_COPY(path, 0);
    PG_RETURN_LSEG_P(lseg);
}

PG_FUNCTION_INFO_V1(poly_link);
Datum
poly_link(PG_FUNCTION_ARGS) {
    POLYGON *poly = PG_GETARG_POLYGON_P(0);
    LSEG    *lseg;

    if  (PG_ARGISNULL(0) || (poly->npts < 1)) PG_RETURN_NULL();
    lseg = (LSEG*)palloc(sizeof(LSEG));
    lseg->p[0].x = poly->p[0].x;
    lseg->p[0].y = poly->p[0].y;
    lseg->p[1].x = poly->p[poly->npts - 1].x;
    lseg->p[1].y = poly->p[poly->npts - 1].y;
    PG_FREE_IF_COPY(poly, 0);
    PG_RETURN_LSEG_P(lseg);
}

// path_add(path,path)=path
