--#
--# Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
--# PKG = babolo_pglib
--# All rights reserved.
--#
--# Redistribution and use in source and binary forms, with or without
--# modification, are permitted provided that the following conditions
--# are met:
--# 1. Redistributions of source code must retain the above copyright
--#    notice, this list of conditions and the following disclaimer.
--# 2. Redistributions in binary form must reproduce the above copyright
--#    notice, this list of conditions and the following disclaimer in the
--#    documentation and/or other materials provided with the distribution.
--#
--# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
--# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
--# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
--# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
--# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
--# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
--# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
--# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
--# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
--# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
--# SUCH DAMAGE.
--#
--# $Id: babolo_pglib--2.00.sql.m4,v 1.16 2022/01/29 22:20:00 babolo Exp $

CREATE OR REPLACE FUNCTION @extschema@.anyequ(anyelement, anyelement) RETURNS bool
 AS 'SELECT $1 IS NOT DISTINCT FROM $2'
 LANGUAGE SQL IMMUTABLE PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.anyequ(anyelement, anyelement)
 IS '  IS NOT DISTINCT'
;
CREATE OR REPLACE FUNCTION @extschema@.anyneq(anyelement, anyelement) RETURNS bool
 AS 'SELECT $1 IS DISTINCT FROM $2'
 LANGUAGE SQL IMMUTABLE PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.anyneq(anyelement, anyelement)
 IS '  IS DISTINCT'
;
CREATE OPERATOR @extschema@.==*
     ( LEFTARG    = anyelement
     , RIGHTARG   = anyelement
     , PROCEDURE  = @extschema@.anyequ
     , COMMUTATOR = ==*
     , NEGATOR    = !=*
     , RESTRICT   = eqsel
     , JOIN       = eqjoinsel
     , HASHES
     , MERGES
     )
;
COMMENT ON OPERATOR @extschema@.==* (anyelement, anyelement)
 IS '  IS NOT DISTINCT'
;
CREATE OPERATOR @extschema@.!=*
     ( LEFTARG    = anyelement
     , RIGHTARG   = anyelement
     , PROCEDURE  = @extschema@.anyneq
     , COMMUTATOR = !=*
     , NEGATOR    = ==*
     , RESTRICT   = neqsel
     , JOIN       = neqjoinsel
     , HASHES
     , MERGES
     )
;
COMMENT ON OPERATOR @extschema@.!=* (anyelement, anyelement)
 IS '  IS DISTINCT'
;
-- CREATE OPERATOR CLASS anyelement_oops FOR TYPE anyelement USING btree
--  AS OPERATOR 1 <
--   , OPERATOR 2 <=
--   , OPERATOR 3 ==*
--   , OPERATOR 4 >=
--   , OPERATOR 5 >
--   , FUNCTION 1 anyequ(anyelement, anyelement)
-- ;
--########################################################################
--#  pglib_text
--########################################################################

CREATE OR REPLACE FUNCTION @extschema@.quote_html(text) RETURNS text
 AS 'MODULE_PATHNAME/pglib_text.so.VMAJOR', 'quote_html'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.quote_html(text)
 IS '  html'
;
CREATE OR REPLACE FUNCTION @extschema@.quote_sh(text) RETURNS text
 AS 'MODULE_PATHNAME/pglib_text.so.VMAJOR', 'quote_sh'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.quote_sh(text)
 IS '  sh'
;
CREATE OR REPLACE FUNCTION @extschema@.quote_copy(text) RETURNS text
 AS 'MODULE_PATHNAME/pglib_text.so.VMAJOR', 'quote_copy'
 LANGUAGE C IMMUTABLE PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.quote_copy(text)
 IS '  COPY'
;
CREATE OR REPLACE FUNCTION @extschema@.compare(integer, text[], text[]) RETURNS bool
 AS 'SELECT CASE WHEN $1 IS NULL
                 THEN FALSE
                 WHEN $2 IS NULL AND $3 IS NULL
                 THEN TRUE
                 WHEN $2 IS NULL OR $3 IS NULL
                 THEN FALSE
                 WHEN array_lower($2, 1) <> array_lower($3, 1)
                   OR (   array_upper($2, 1) <> array_upper($3, 1)
                      AND (array_upper($2, 1) < $1 OR array_upper($3, 1) < $1)
                      )
                 THEN FALSE
                 WHEN array_lower($2, 1) > $1
                 THEN TRUE
                 WHEN array_upper($2, 1) > $1
                 THEN $2[array_lower($2, 1):$1] = $3[array_lower($3, 1):$1]
                 ELSE $2 = $3
            END
    '
 LANGUAGE SQL IMMUTABLE PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.compare(integer, text[], text[])
 IS '  $1   $2  $3'
;
--########################################################################
--#  pglib_bytea
--########################################################################

CREATE OR REPLACE FUNCTION @extschema@.bytea(int4, int4) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'int4_bytea'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytea(int4, int4)
 IS '      ,   '
;
CREATE OR REPLACE FUNCTION @extschema@.bytea(int4) RETURNS bytea
 AS 'SELECT bytea($1, 4)'
 LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytea(int4)
 IS '    bytea'
;
CREATE OR REPLACE FUNCTION @extschema@.bytea(int8, int4) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'int8_bytea'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytea(int8, int4)
 IS '      ,   '
;
CREATE OR REPLACE FUNCTION @extschema@.bytea(int8) RETURNS bytea
 AS 'SELECT bytea($1, 8)'
 LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytea(int8)
 IS '    bytea'
;
CREATE OR REPLACE FUNCTION @extschema@.int8(bytea) RETURNS int8
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'bytea_int8'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.int8(bytea)
 IS '     int8'
;
CREATE OR REPLACE FUNCTION @extschema@.bytea(text) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'text_bytea'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytea(text)
 IS '    bytea'
;
CREATE OR REPLACE FUNCTION @extschema@.text(bytea) RETURNS text
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'bytea_text'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.text(bytea)
 IS '    text'
;
CREATE OR REPLACE FUNCTION @extschema@.bytearradd(bytea, bytea) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'bytearradd'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytearradd(bytea, bytea)
 IS '      <= 255'
;
CREATE OR REPLACE FUNCTION @extschema@.bytearrmax(bytea) RETURNS int4
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'bytearrmax'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bytearrmax(bytea)
 IS '     '
;
CREATE IFOVER(12, OR REPLACE) AGGREGATE @extschema@.bytearrsum
     (bytea)
     ( SFUNC       = @extschema@.bytearradd
     , STYPE       = bytea
     , SSPACE      = 12
     , INITCOND    = ''
     , COMBINEFUNC = @extschema@.bytearradd
     , PARALLEL    = SAFE
     )
;
COMMENT ON AGGREGATE @extschema@.bytearrsum(bytea)
 IS '    <= 255'
;
--########################################################################
--#  pglib_bit
--########################################################################

--#          --
--#-------------------------------------------------------------
CREATE OR REPLACE FUNCTION @extschema@.num2bit(integer) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'num2bit'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.num2bit(integer)
 IS ' varbit      ,       '
;
CREATE OR REPLACE FUNCTION @extschema@.bit2num(varbit) RETURNS SETOF int4
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bit2num'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bit2num(varbit)
 IS '   ,        ,       '
;
--# / varbit --
--#---------------------
CREATE OR REPLACE FUNCTION @extschema@.varbit(text) RETURNS varbit
 AS 'DECLARE
        i int;
        r varbit;
        c char;
     BEGIN
        r := ''''::varbit;
        FOR i IN 1..length($1) LOOP
           c := substr($1, i, 1);
           IF c = ''1''
           THEN r := varbitor(r, bitex0(''1''::varbit, i) >> (i - 1));
           ELSIF c <> ''0''
           THEN RAISE EXCEPTION ''"%" is not a valid binary digit'', c;
           END IF;
        END LOOP;
        RETURN r;
     END;
    '
 LANGUAGE 'plpgsql' IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbit(text)
 IS '   varbit'
;
CREATE OR REPLACE FUNCTION @extschema@.text(varbit) RETURNS text 
 AS 'DECLARE
        i int;
        t text;
     BEGIN
        t := ''''::text;
        FOR i IN 1..bit_length($1) LOOP
           IF boolor(varbitand($1, (bitex0(''1''::varbit, i) >> (i - 1))))
           THEN t := t || ''1'';
           ELSE t := t || ''0'';
           END IF;
        END LOOP;
        RETURN t;
     END;
    '
 LANGUAGE 'plpgsql' IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.text(varbit)
 IS ' varbit  '
;
--#  bool --
--#-------------------

CREATE IFOVER(12, OR REPLACE) AGGREGATE @extschema@.bit_xor(int)
     ( SFUNC = int4xor
     , STYPE = int
     )
;
COMMENT ON AGGREGATE @extschema@.bit_xor(int)
 IS 'bitwise-xor int4 aggregate'
;
CREATE IFOVER(12, OR REPLACE) AGGREGATE @extschema@.bit_xor(int8)
     ( SFUNC = int8xor
     , STYPE = int8
     )
;
COMMENT ON AGGREGATE @extschema@.bit_xor(int8)
 IS 'bitwise-xor int8 aggregate'
;
