--#
--# Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
--# PKG = babolo_pglib
--# All rights reserved.
--#
--# Redistribution and use in source and binary forms, with or without
--# modification, are permitted provided that the following conditions
--# are met:
--# 1. Redistributions of source code must retain the above copyright
--#    notice, this list of conditions and the following disclaimer.
--# 2. Redistributions in binary form must reproduce the above copyright
--#    notice, this list of conditions and the following disclaimer in the
--#    documentation and/or other materials provided with the distribution.
--#
--# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
--# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
--# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
--# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
--# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
--# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
--# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
--# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
--# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
--# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
--# SUCH DAMAGE.
--#
--# $Id: babolo_pglib--2.03.sql.m4,v 1.1 2022/01/29 22:20:00 babolo Exp $

--########################################################################
--#  pglib_bytea
--########################################################################

CREATE OR REPLACE FUNCTION @extschema@.bytearrmask(bytea, varbit) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bytearrmask'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION @extschema@.bytearrmask(bytea, varbit)
 IS '      '
;
--########################################################################
--#  pglib_bit
--########################################################################

--#    --
--#----------------------------
CREATE OR REPLACE FUNCTION @extschema@.bitex0(varbit, int4) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bitex0'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bitex0(varbit, int4)
 IS '   ,    0'
;
CREATE OR REPLACE FUNCTION @extschema@.bitex1(varbit, int4) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bitex1'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.bitex1(varbit, int4)
 IS '   ,    1'
;
--#  varbit  bool  AND  OR --
--#-------------------------------------
CREATE OR REPLACE FUNCTION @extschema@.boolor(varbit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'boolor'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.boolor(varbit)
 IS 'OR    '
;
CREATE OR REPLACE FUNCTION @extschema@.booland(varbit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'booland'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.booland(varbit)
 IS 'AND    '
;
--#    , ,            --
--#    ,    --
--#----------------------------------------------------------------------
CREATE OR REPLACE FUNCTION @extschema@.varbiteq(varbit, varbit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbiteq'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbiteq(varbit, varbit)
 IS '    '
;
CREATE OR REPLACE FUNCTION @extschema@.varbitand(varbit, varbit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitand'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitand(varbit, varbit)
 IS 'AND      '
;
CREATE OR REPLACE FUNCTION @extschema@.varbitor(varbit, varbit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitor'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitor(varbit, varbit)
 IS 'OR      '
;
CREATE OR REPLACE FUNCTION @extschema@.varbitxor(varbit, varbit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitxor'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitxor(varbit, varbit)
 IS 'XOR      '
;
CREATE OR REPLACE FUNCTION @extschema@.varbitrst(varbit, varbit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitrst'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitrst(varbit, varbit)
 IS '$1 AND ~$2,       '
;
CREATE OR REPLACE FUNCTION @extschema@.varbitmeq(varbit, varbit, varbit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitmeq'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitmeq(varbit, varbit, varbit)
 IS '$1  $2    $3'
;
CREATE OPERATOR @extschema@.==
     ( LEFTARG    = varbit
     , RIGHTARG   = varbit
     , PROCEDURE  = @extschema@.varbiteq
     , COMMUTATOR = ==
     )
;
COMMENT ON OPERATOR @extschema@.== (varbit, varbit)
 IS '    '
;
CREATE OPERATOR @extschema@./|
     ( LEFTARG    = varbit
     , RIGHTARG   = varbit
     , PROCEDURE  = @extschema@.varbitand
     , COMMUTATOR = /|
     )
;
COMMENT ON OPERATOR @extschema@./| (varbit, varbit)
 IS 'AND      '
;
CREATE OPERATOR @extschema@.|/
     ( LEFTARG    = varbit
     , RIGHTARG   = varbit
     , PROCEDURE  = @extschema@.varbitor
     , COMMUTATOR = |/
     )
;
COMMENT ON OPERATOR @extschema@.|/ (varbit, varbit)
 IS 'OR      '
;
CREATE OPERATOR @extschema@./|/
     ( LEFTARG    = varbit
     , RIGHTARG   = varbit
     , PROCEDURE  = @extschema@.varbitxor
     , COMMUTATOR = /|/
     )
;
COMMENT ON OPERATOR @extschema@./|/ (varbit, varbit)
 IS 'XOR      '
;
CREATE OPERATOR @extschema@.!
     ( LEFTARG   = varbit
     , RIGHTARG  = varbit
     , PROCEDURE = @extschema@.varbitrst
     )
;
COMMENT ON OPERATOR @extschema@.! (varbit, varbit)
 IS '$1 AND ~$2,       '
;
--#  varbit  AND  OR --
--#---------------------------------
CREATE OR REPLACE FUNCTION @extschema@.varbitandn(varbit, varbit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitand'
 LANGUAGE C IMMUTABLE PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitandn(varbit, varbit)
 IS 'varbitand  '
;
CREATE OR REPLACE FUNCTION @extschema@.varbitorn(varbit, varbit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitor'
 LANGUAGE C IMMUTABLE PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.varbitorn(varbit, varbit)
 IS 'varbitor  '
;
CREATE IFOVER(12, OR REPLACE) AGGREGATE @extschema@.conjunction
     ( BASETYPE = varbit
     , SFUNC    = @extschema@.varbitandn
     , STYPE    = varbit
     )
;
COMMENT ON AGGREGATE @extschema@.conjunction(varbit)
 IS ' AND  varbit'
;
CREATE IFOVER(12, OR REPLACE) AGGREGATE @extschema@.disjunction
     ( BASETYPE = varbit
     , SFUNC    = @extschema@.varbitorn
     , STYPE    = varbit
     )
;
COMMENT ON AGGREGATE @extschema@.disjunction(varbit)
 IS ' OR  varbit'
;
