--#
--# Copyright (C)2002..2022 @BABOLO http://www.babolo.ru/
--# PKG = babolo_pglib
--# All rights reserved.
--#
--# Redistribution and use in source and binary forms, with or without
--# modification, are permitted provided that the following conditions
--# are met:
--# 1. Redistributions of source code must retain the above copyright
--#    notice, this list of conditions and the following disclaimer.
--# 2. Redistributions in binary form must reproduce the above copyright
--#    notice, this list of conditions and the following disclaimer in the
--#    documentation and/or other materials provided with the distribution.
--#
--# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
--# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
--# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
--# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
--# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
--# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
--# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
--# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
--# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
--# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
--# SUCH DAMAGE.
--#
--# $Id: babolo_pglib--2.04.sql.m4,v 1.17 2022/01/29 22:20:00 babolo Exp $

--########################################################################
--#  pglib_ip
--########################################################################

CREATE OR REPLACE FUNCTION @extschema@.inet(int4) RETURNS inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'int4_inet'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.inet(int4)
 IS ' int4  IP '
;
CREATE OR REPLACE FUNCTION @extschema@.inet(int8) RETURNS inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'int8_inet'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.inet(int8)
 IS ' int8  IP '
;
CREATE OR REPLACE FUNCTION @extschema@.int4(inet) RETURNS int4
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'inet_int4'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.int4(inet)
 IS ' IP   int4'
;
CREATE OR REPLACE FUNCTION @extschema@.int8(inet) RETURNS int8
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'inet_int8'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.int8(inet)
 IS ' IP   int8'
;
CREATE OR REPLACE FUNCTION @extschema@.ip_set(inet, int) RETURNS SETOF inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ip_set'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.ip_set(inet, int)
 IS '       '
;
CREATE OR REPLACE FUNCTION @extschema@.ip_set(inet) RETURNS SETOF inet
 AS 'SELECT ip_set($1, 32)'
 LANGUAGE SQL IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.ip_set(inet)
 IS '    '
;
CREATE OR REPLACE FUNCTION @extschema@.ip_supernet(inet) RETURNS SETOF inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ip_supernet'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.ip_supernet(inet)
 IS '    '
;
--#
CREATE OR REPLACE FUNCTION @extschema@.ipaggr_in(cstring) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ipaggr_in'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.ipaggr_in(cstring)
 IS '   IP '
;
CREATE OR REPLACE FUNCTION @extschema@.ipaggr_out(ipaggr) RETURNS cstring
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ipaggr_out'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.ipaggr_out(ipaggr)
 IS ' IP   '
;
CREATE OR REPLACE FUNCTION @extschema@.add_net(ipaggr, inet) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'add_net'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.add_net(ipaggr, inet)
 IS '  IP  '
;
CREATE OR REPLACE FUNCTION @extschema@.sub_net(ipaggr, inet) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'sub_net'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.sub_net(ipaggr, inet)
 IS '  IP  '
;
CREATE OR REPLACE FUNCTION @extschema@.add_ipaggr(ipaggr, ipaggr) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'add_ipaggr'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.add_ipaggr(ipaggr, ipaggr)
 IS '  IP '
;
CREATE OR REPLACE FUNCTION @extschema@.sub_ipaggr(ipaggr, ipaggr) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'sub_ipaggr'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.sub_ipaggr(ipaggr, ipaggr)
 IS '  IP '
;
CREATE OR REPLACE FUNCTION @extschema@.inter_ipaggr(ipaggr, ipaggr) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'inter_ipaggr'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.inter_ipaggr(ipaggr, ipaggr)
 IS '   IP '
;
CREATE OR REPLACE FUNCTION @extschema@.show_net(ipaggr) RETURNS SETOF cidr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'show_net'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.show_net(ipaggr)
 IS ' IP    '
;
CREATE OR REPLACE FUNCTION @extschema@.check_net(ipaggr, inet) RETURNS boolean
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'check_net'
 LANGUAGE C IMMUTABLE STRICT PARALLEL SAFE
;
COMMENT ON FUNCTION @extschema@.check_net(ipaggr, inet)
 IS '  inet   ipaggr'
;
CREATE TYPE @extschema@.ipaggr
     ( INTERNALLENGTH = VARIABLE
     , INPUT          = @extschema@.ipaggr_in
     , OUTPUT         = @extschema@.ipaggr_out
     , ALIGNMENT      = double
     , STORAGE        = external
     )
;
COMMENT ON TYPE @extschema@.ipaggr
 IS ' IPv4 '
;
CREATE IFOVER(12, OR REPLACE) AGGREGATE @extschema@.sum_net
     ( SFUNC    = @extschema@.add_net
     , BASETYPE = inet
     , STYPE    = @extschema@.ipaggr
     , INITCOND = 'f'
     )
;
COMMENT ON AGGREGATE @extschema@.sum_net(inet)
 IS '   IP '
;
CREATE OPERATOR @extschema@.+
     ( LEFTARG    = @extschema@.ipaggr
     , RIGHTARG   = @extschema@.ipaggr
     , PROCEDURE  = @extschema@.add_ipaggr
     , COMMUTATOR = +
);
COMMENT ON OPERATOR @extschema@.+ (@extschema@.ipaggr, @extschema@.ipaggr)
 IS ' IP '
;
CREATE OPERATOR @extschema@.-
     ( LEFTARG    = @extschema@.ipaggr
     , RIGHTARG   = @extschema@.ipaggr
     , PROCEDURE  = @extschema@.sub_ipaggr
     , COMMUTATOR = -
     )
;
COMMENT ON OPERATOR @extschema@.- (@extschema@.ipaggr, @extschema@.ipaggr)
 IS ' IP '
;
CREATE OPERATOR @extschema@.*
     ( LEFTARG    = @extschema@.ipaggr
     , RIGHTARG   = @extschema@.ipaggr
     , PROCEDURE  = @extschema@.inter_ipaggr
     , COMMUTATOR = *
     )
;
COMMENT ON OPERATOR @extschema@.* (@extschema@.ipaggr, @extschema@.ipaggr)
 IS ' IP '
;
CREATE OPERATOR @extschema@.+
     ( LEFTARG    = @extschema@.ipaggr
     , RIGHTARG   = inet
     , PROCEDURE  = @extschema@.add_net
     )
;
COMMENT ON OPERATOR @extschema@.+ (@extschema@.ipaggr, inet)
 IS ' IP   IP '
;
CREATE OPERATOR @extschema@.-
     ( LEFTARG    = @extschema@.ipaggr
     , RIGHTARG   = inet
     , PROCEDURE  = @extschema@.sub_net
     )
;
COMMENT ON OPERATOR @extschema@.- (@extschema@.ipaggr, inet)
 IS ' IP   IP '
;
