#!/bin/sh
# Copyright (C)2013..2025 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: regres.m4,v 1.7 2025/02/03 13:30:26 babolo Exp $

TO=`mktemp -t json2pgXXXX` || exit 1
TI=`mktemp -t json2pgXXXX` || exit 1
prog="`pwd`/json2pg"
e=0


echo '= 0 === -D'

DOTEST(-D,"erty"dnl
,string  =erty~)
DOTEST(-D,1dnl
,int     =1)
DOTEST(-D,1.5dnl
,double  =1.5)
DOTEST(-D,truednl
,boolean =1)
DOTEST(-D,falsednl
,boolean =0)
DOTEST(-D,{"e":1}dnl
,int     e=1)
DOTEST(-D,{"e":1,"r":5.3,"q":"erw","t":true}dnl
,int     e=1
double  r=5.3
string  q=erw~
boolean t=1)
DOTEST(-D,[1,2,3,4,5,6]dnl
,int     0=1
int     1=2
int     2=3
int     3=4
int     4=5
int     5=6)
DOTEST(-D,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,int     0.e=1
double  0.r=5.3
int     1.e=2
double  1.r=5.4
int     2.e=3
double  2.r=5.5)
DOTEST(-D,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,int     r.0.e=1
double  r.0.r=5.3
int     r.1.e=2
double  r.1.r=5.4
boolean Y=1)
DOTEST(-D,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,string  i=II~
string  j=JJ~
string  k=KK~
string  l=LL~
string  Y=yy~)
DOTEST(-D,{"o":{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}}dnl
,string  o.i=II~
string  o.j=JJ~
string  o.k=KK~
string  o.l=LL~
string  o.Y=yy~)
DOTEST(-D,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,string  schedule.ownerLocRef.refUid=40000000-0000-0000-0000-000000000005~
string  schedule.ownerLocRef.refName=System~
string  schedule.ownerLocRef.refObjectType=location~
string  schedule.timeCategorys.0.name=Weekdays~
string  schedule.timeCategorys.0.colorCode=T0~
string  schedule.timeCategorys.1.name=Nights and Weekends~
string  schedule.timeCategorys.1.colorCode=T1~
string  schedule.timeCategorys.2.name=~
string  schedule.timeCategorys.2.colorCode=T2~
string  schedule.timeCategorys.3.name=~
string  schedule.timeCategorys.3.colorCode=T3~
string  schedule.timeCategorys.4.name=~
string  schedule.timeCategorys.4.colorCode=T4~
string  schedule.timeCategorys.5.name=~
string  schedule.timeCategorys.5.colorCode=T5~
string  schedule.timeCategorys.6.name=~
string  schedule.timeCategorys.6.colorCode=T6~
string  schedule.timeCategorys.7.name=~
string  schedule.timeCategorys.7.colorCode=T7~
string  schedule.weeklySchedules.0.name=Weekly Schedule 1~
string  schedule.weeklySchedules.0.dailySchedules.0.dayOfWeek=MON~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.1.dayOfWeek=TUE~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.2.dayOfWeek=WED~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.3.dayOfWeek=THU~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.4.dayOfWeek=FRI~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.5.dayOfWeek=SAT~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.0.dailySchedules.6.dayOfWeek=SUN~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.name=Weekly Schedule 2~
string  schedule.weeklySchedules.1.startDate=07-01-2011~
string  schedule.weeklySchedules.1.dailySchedules.0.dayOfWeek=MON~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.1.dayOfWeek=TUE~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.2.dayOfWeek=WED~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.3.dayOfWeek=THU~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.4.dayOfWeek=FRI~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.colorCode=T0~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.5.dayOfWeek=SAT~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.colorCode=T1~
string  schedule.weeklySchedules.1.dailySchedules.6.dayOfWeek=SUN~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.colorCode=T1~
string  schedule.specialDaySchedules.0.name=Special Day 1~
string  schedule.specialDaySchedules.0.startDate=07-04-2011~
string  schedule.specialDaySchedules.0.endDate=07-04-2011~
string  schedule.specialDaySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.specialDaySchedules.0.timeSlices.0.endTime=09:00:00~
string  schedule.specialDaySchedules.0.timeSlices.0.colorCode=T1~
string  schedule.specialDaySchedules.0.timeSlices.1.startTime=09:00:00~
string  schedule.specialDaySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.specialDaySchedules.0.timeSlices.1.colorCode=T0~
string  schedule.specialDaySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.specialDaySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.specialDaySchedules.0.timeSlices.2.colorCode=T1~
string  schedule.specialDaySchedules.1.name=Special Days 2 ~
string  schedule.specialDaySchedules.1.startDate=12-24-2011~
string  schedule.specialDaySchedules.1.endDate=12-26-2011~
string  schedule.specialDaySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.specialDaySchedules.1.timeSlices.0.endTime=09:00:00~
string  schedule.specialDaySchedules.1.timeSlices.0.colorCode=T1~
string  schedule.specialDaySchedules.1.timeSlices.1.startTime=09:00:00~
string  schedule.specialDaySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.specialDaySchedules.1.timeSlices.1.colorCode=T0~
string  schedule.specialDaySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.specialDaySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.specialDaySchedules.1.timeSlices.2.colorCode=T1~
string  schedule.name=Sample Schedule~
string  schedule.tags=Sample Tags~
string  schedule.description=Sample Description~
string  schedule.objectType=vs_schedule~)


echo '= 1 === -DD'

DOTEST(-DD,"erty"dnl
,string  =erty~)
DOTEST(-DD,1dnl
,int     =1)
DOTEST(-DD,1.5dnl
,double  =1.5)
DOTEST(-DD,truednl
,boolean =1)
DOTEST(-DD,falsednl
,boolean =0)
DOTEST(-DD,{"e":1}dnl
,object  
int     e=1)
DOTEST(-DD,{"e":1,"r":5.3,"q":"tyui","t":false}dnl
,object  
int     e=1
double  r=5.3
string  q=tyui~
boolean t=0)
DOTEST(-DD,[1,2,3,4,5,6]dnl
,array   
int     0=1
int     1=2
int     2=3
int     3=4
int     4=5
int     5=6)
DOTEST(-DD,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,array   
object  0
int     0.e=1
double  0.r=5.3
object  1
int     1.e=2
double  1.r=5.4
object  2
int     2.e=3
double  2.r=5.5)
DOTEST(-DD,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,object  
array   r
object  r.0
int     r.0.e=1
double  r.0.r=5.3
object  r.1
int     r.1.e=2
double  r.1.r=5.4
boolean Y=1)
DOTEST(-DD,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,object  
string  i=II~
string  j=JJ~
string  k=KK~
string  l=LL~
string  Y=yy~)
DOTEST(-DD,{"o":{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}}dnl
,object  
object  o
string  o.i=II~
string  o.j=JJ~
string  o.k=KK~
string  o.l=LL~
string  o.Y=yy~)
DOTEST(-DD,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,object  
object  schedule
object  schedule.ownerLocRef
string  schedule.ownerLocRef.refUid=40000000-0000-0000-0000-000000000005~
string  schedule.ownerLocRef.refName=System~
string  schedule.ownerLocRef.refObjectType=location~
array   schedule.timeCategorys
object  schedule.timeCategorys.0
string  schedule.timeCategorys.0.name=Weekdays~
string  schedule.timeCategorys.0.colorCode=T0~
object  schedule.timeCategorys.1
string  schedule.timeCategorys.1.name=Nights and Weekends~
string  schedule.timeCategorys.1.colorCode=T1~
object  schedule.timeCategorys.2
string  schedule.timeCategorys.2.name=~
string  schedule.timeCategorys.2.colorCode=T2~
object  schedule.timeCategorys.3
string  schedule.timeCategorys.3.name=~
string  schedule.timeCategorys.3.colorCode=T3~
object  schedule.timeCategorys.4
string  schedule.timeCategorys.4.name=~
string  schedule.timeCategorys.4.colorCode=T4~
object  schedule.timeCategorys.5
string  schedule.timeCategorys.5.name=~
string  schedule.timeCategorys.5.colorCode=T5~
object  schedule.timeCategorys.6
string  schedule.timeCategorys.6.name=~
string  schedule.timeCategorys.6.colorCode=T6~
object  schedule.timeCategorys.7
string  schedule.timeCategorys.7.name=~
string  schedule.timeCategorys.7.colorCode=T7~
array   schedule.weeklySchedules
object  schedule.weeklySchedules.0
string  schedule.weeklySchedules.0.name=Weekly Schedule 1~
array   schedule.weeklySchedules.0.dailySchedules
object  schedule.weeklySchedules.0.dailySchedules.0
string  schedule.weeklySchedules.0.dailySchedules.0.dayOfWeek=MON~
array   schedule.weeklySchedules.0.dailySchedules.0.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.1
string  schedule.weeklySchedules.0.dailySchedules.1.dayOfWeek=TUE~
array   schedule.weeklySchedules.0.dailySchedules.1.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.2
string  schedule.weeklySchedules.0.dailySchedules.2.dayOfWeek=WED~
array   schedule.weeklySchedules.0.dailySchedules.2.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.3
string  schedule.weeklySchedules.0.dailySchedules.3.dayOfWeek=THU~
array   schedule.weeklySchedules.0.dailySchedules.3.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.4
string  schedule.weeklySchedules.0.dailySchedules.4.dayOfWeek=FRI~
array   schedule.weeklySchedules.0.dailySchedules.4.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.5
string  schedule.weeklySchedules.0.dailySchedules.5.dayOfWeek=SAT~
array   schedule.weeklySchedules.0.dailySchedules.5.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.6
string  schedule.weeklySchedules.0.dailySchedules.6.dayOfWeek=SUN~
array   schedule.weeklySchedules.0.dailySchedules.6.timeSlices
object  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1
string  schedule.weeklySchedules.1.name=Weekly Schedule 2~
string  schedule.weeklySchedules.1.startDate=07-01-2011~
array   schedule.weeklySchedules.1.dailySchedules
object  schedule.weeklySchedules.1.dailySchedules.0
string  schedule.weeklySchedules.1.dailySchedules.0.dayOfWeek=MON~
array   schedule.weeklySchedules.1.dailySchedules.0.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.1
string  schedule.weeklySchedules.1.dailySchedules.1.dayOfWeek=TUE~
array   schedule.weeklySchedules.1.dailySchedules.1.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.2
string  schedule.weeklySchedules.1.dailySchedules.2.dayOfWeek=WED~
array   schedule.weeklySchedules.1.dailySchedules.2.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.3
string  schedule.weeklySchedules.1.dailySchedules.3.dayOfWeek=THU~
array   schedule.weeklySchedules.1.dailySchedules.3.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.4
string  schedule.weeklySchedules.1.dailySchedules.4.dayOfWeek=FRI~
array   schedule.weeklySchedules.1.dailySchedules.4.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.5
string  schedule.weeklySchedules.1.dailySchedules.5.dayOfWeek=SAT~
array   schedule.weeklySchedules.1.dailySchedules.5.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.6
string  schedule.weeklySchedules.1.dailySchedules.6.dayOfWeek=SUN~
array   schedule.weeklySchedules.1.dailySchedules.6.timeSlices
object  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.colorCode=T1~
array   schedule.specialDaySchedules
object  schedule.specialDaySchedules.0
string  schedule.specialDaySchedules.0.name=Special Day 1~
string  schedule.specialDaySchedules.0.startDate=07-04-2011~
string  schedule.specialDaySchedules.0.endDate=07-04-2011~
array   schedule.specialDaySchedules.0.timeSlices
object  schedule.specialDaySchedules.0.timeSlices.0
string  schedule.specialDaySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.specialDaySchedules.0.timeSlices.0.endTime=09:00:00~
string  schedule.specialDaySchedules.0.timeSlices.0.colorCode=T1~
object  schedule.specialDaySchedules.0.timeSlices.1
string  schedule.specialDaySchedules.0.timeSlices.1.startTime=09:00:00~
string  schedule.specialDaySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.specialDaySchedules.0.timeSlices.1.colorCode=T0~
object  schedule.specialDaySchedules.0.timeSlices.2
string  schedule.specialDaySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.specialDaySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.specialDaySchedules.0.timeSlices.2.colorCode=T1~
object  schedule.specialDaySchedules.1
string  schedule.specialDaySchedules.1.name=Special Days 2 ~
string  schedule.specialDaySchedules.1.startDate=12-24-2011~
string  schedule.specialDaySchedules.1.endDate=12-26-2011~
array   schedule.specialDaySchedules.1.timeSlices
object  schedule.specialDaySchedules.1.timeSlices.0
string  schedule.specialDaySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.specialDaySchedules.1.timeSlices.0.endTime=09:00:00~
string  schedule.specialDaySchedules.1.timeSlices.0.colorCode=T1~
object  schedule.specialDaySchedules.1.timeSlices.1
string  schedule.specialDaySchedules.1.timeSlices.1.startTime=09:00:00~
string  schedule.specialDaySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.specialDaySchedules.1.timeSlices.1.colorCode=T0~
object  schedule.specialDaySchedules.1.timeSlices.2
string  schedule.specialDaySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.specialDaySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.specialDaySchedules.1.timeSlices.2.colorCode=T1~
string  schedule.name=Sample Schedule~
string  schedule.tags=Sample Tags~
string  schedule.description=Sample Description~
string  schedule.objectType=vs_schedule~)


echo '= 2 === -DDD'

DOTEST(-DDD,"erty"dnl
,string  =erty~)
DOTEST(-DDD,1dnl
,int     =1)
DOTEST(-DDD,1.5dnl
,double  =1.5)
DOTEST(-DDD,truednl
,boolean =1)
DOTEST(-DDD,falsednl
,boolean =0)
DOTEST(-DDD,{"e":1}dnl
,object  ={ "e": 1 }~
int     e=1)
DOTEST(-DDD,{"e":1,"r":5.3,"q":"tyui","t":false}dnl
,object  ={ "e": 1, "r": 5.3, "q": "tyui", "t": false }~
int     e=1
double  r=5.3
string  q=tyui~
boolean t=0)
DOTEST(-DDD,[1,2,3,4,5,6]dnl
,array   =[ 1, 2, 3, 4, 5, 6 ]~
int     0=1
int     1=2
int     2=3
int     3=4
int     4=5
int     5=6)
DOTEST(-DDD,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,array   =[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 }, { "e": 3, "r": 5.5 } ]~
object  0={ "e": 1, "r": 5.3 }~
int     0.e=1
double  0.r=5.3
object  1={ "e": 2, "r": 5.4 }~
int     1.e=2
double  1.r=5.4
object  2={ "e": 3, "r": 5.5 }~
int     2.e=3
double  2.r=5.5)
DOTEST(-DDD,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,object  ={ "r": [ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ], "Y": true }~
array   r=[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ]~
object  r.0={ "e": 1, "r": 5.3 }~
int     r.0.e=1
double  r.0.r=5.3
object  r.1={ "e": 2, "r": 5.4 }~
int     r.1.e=2
double  r.1.r=5.4
boolean Y=1)
DOTEST(-DDD,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,object  ={ "i": "II", "j": "JJ", "k": "KK", "l": "LL", "Y": "yy" }~
string  i=II~
string  j=JJ~
string  k=KK~
string  l=LL~
string  Y=yy~)
DOTEST(-DDD,{"o":{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}}dnl
,object  ={ "o": { "i": "II", "j": "JJ", "k": "KK", "l": "LL", "Y": "yy" } }~
object  o={ "i": "II", "j": "JJ", "k": "KK", "l": "LL", "Y": "yy" }~
string  o.i=II~
string  o.j=JJ~
string  o.k=KK~
string  o.l=LL~
string  o.Y=yy~)
DOTEST(-DDD,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,object  ={ "schedule": { "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" } }~
object  schedule={ "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" }~
object  schedule.ownerLocRef={ "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }~
string  schedule.ownerLocRef.refUid=40000000-0000-0000-0000-000000000005~
string  schedule.ownerLocRef.refName=System~
string  schedule.ownerLocRef.refObjectType=location~
array   schedule.timeCategorys=[ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ]~
object  schedule.timeCategorys.0={ "name": "Weekdays", "colorCode": "T0" }~
string  schedule.timeCategorys.0.name=Weekdays~
string  schedule.timeCategorys.0.colorCode=T0~
object  schedule.timeCategorys.1={ "name": "Nights and Weekends", "colorCode": "T1" }~
string  schedule.timeCategorys.1.name=Nights and Weekends~
string  schedule.timeCategorys.1.colorCode=T1~
object  schedule.timeCategorys.2={ "name": "", "colorCode": "T2" }~
string  schedule.timeCategorys.2.name=~
string  schedule.timeCategorys.2.colorCode=T2~
object  schedule.timeCategorys.3={ "name": "", "colorCode": "T3" }~
string  schedule.timeCategorys.3.name=~
string  schedule.timeCategorys.3.colorCode=T3~
object  schedule.timeCategorys.4={ "name": "", "colorCode": "T4" }~
string  schedule.timeCategorys.4.name=~
string  schedule.timeCategorys.4.colorCode=T4~
object  schedule.timeCategorys.5={ "name": "", "colorCode": "T5" }~
string  schedule.timeCategorys.5.name=~
string  schedule.timeCategorys.5.colorCode=T5~
object  schedule.timeCategorys.6={ "name": "", "colorCode": "T6" }~
string  schedule.timeCategorys.6.name=~
string  schedule.timeCategorys.6.colorCode=T6~
object  schedule.timeCategorys.7={ "name": "", "colorCode": "T7" }~
string  schedule.timeCategorys.7.name=~
string  schedule.timeCategorys.7.colorCode=T7~
array   schedule.weeklySchedules=[ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ]~
object  schedule.weeklySchedules.0={ "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }~
string  schedule.weeklySchedules.0.name=Weekly Schedule 1~
array   schedule.weeklySchedules.0.dailySchedules=[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]~
object  schedule.weeklySchedules.0.dailySchedules.0={ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.0.dayOfWeek=MON~
array   schedule.weeklySchedules.0.dailySchedules.0.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.1={ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.1.dayOfWeek=TUE~
array   schedule.weeklySchedules.0.dailySchedules.1.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.2={ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.2.dayOfWeek=WED~
array   schedule.weeklySchedules.0.dailySchedules.2.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.3={ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.3.dayOfWeek=THU~
array   schedule.weeklySchedules.0.dailySchedules.3.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.4={ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.4.dayOfWeek=FRI~
array   schedule.weeklySchedules.0.dailySchedules.4.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.5={ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.5.dayOfWeek=SAT~
array   schedule.weeklySchedules.0.dailySchedules.5.timeSlices=[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0={ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.0.dailySchedules.6={ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.0.dailySchedules.6.dayOfWeek=SUN~
array   schedule.weeklySchedules.0.dailySchedules.6.timeSlices=[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0={ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1={ "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }~
string  schedule.weeklySchedules.1.name=Weekly Schedule 2~
string  schedule.weeklySchedules.1.startDate=07-01-2011~
array   schedule.weeklySchedules.1.dailySchedules=[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]~
object  schedule.weeklySchedules.1.dailySchedules.0={ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.0.dayOfWeek=MON~
array   schedule.weeklySchedules.1.dailySchedules.0.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.1={ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.1.dayOfWeek=TUE~
array   schedule.weeklySchedules.1.dailySchedules.1.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.2={ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.2.dayOfWeek=WED~
array   schedule.weeklySchedules.1.dailySchedules.2.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.3={ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.3.dayOfWeek=THU~
array   schedule.weeklySchedules.1.dailySchedules.3.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.4={ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.4.dayOfWeek=FRI~
array   schedule.weeklySchedules.1.dailySchedules.4.timeSlices=[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0={ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.endTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1={ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.startTime=08:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.endTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.colorCode=T0~
object  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.startTime=17:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.5={ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.5.dayOfWeek=SAT~
array   schedule.weeklySchedules.1.dailySchedules.5.timeSlices=[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0={ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.colorCode=T1~
object  schedule.weeklySchedules.1.dailySchedules.6={ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.weeklySchedules.1.dailySchedules.6.dayOfWeek=SUN~
array   schedule.weeklySchedules.1.dailySchedules.6.timeSlices=[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0={ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.startTime=00:00:00~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.endTime=24:00:00~
string  schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.colorCode=T1~
array   schedule.specialDaySchedules=[ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]~
object  schedule.specialDaySchedules.0={ "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.specialDaySchedules.0.name=Special Day 1~
string  schedule.specialDaySchedules.0.startDate=07-04-2011~
string  schedule.specialDaySchedules.0.endDate=07-04-2011~
array   schedule.specialDaySchedules.0.timeSlices=[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.specialDaySchedules.0.timeSlices.0={ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }~
string  schedule.specialDaySchedules.0.timeSlices.0.startTime=00:00:00~
string  schedule.specialDaySchedules.0.timeSlices.0.endTime=09:00:00~
string  schedule.specialDaySchedules.0.timeSlices.0.colorCode=T1~
object  schedule.specialDaySchedules.0.timeSlices.1={ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.specialDaySchedules.0.timeSlices.1.startTime=09:00:00~
string  schedule.specialDaySchedules.0.timeSlices.1.endTime=17:00:00~
string  schedule.specialDaySchedules.0.timeSlices.1.colorCode=T0~
object  schedule.specialDaySchedules.0.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.specialDaySchedules.0.timeSlices.2.startTime=17:00:00~
string  schedule.specialDaySchedules.0.timeSlices.2.endTime=24:00:00~
string  schedule.specialDaySchedules.0.timeSlices.2.colorCode=T1~
object  schedule.specialDaySchedules.1={ "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }~
string  schedule.specialDaySchedules.1.name=Special Days 2 ~
string  schedule.specialDaySchedules.1.startDate=12-24-2011~
string  schedule.specialDaySchedules.1.endDate=12-26-2011~
array   schedule.specialDaySchedules.1.timeSlices=[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]~
object  schedule.specialDaySchedules.1.timeSlices.0={ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }~
string  schedule.specialDaySchedules.1.timeSlices.0.startTime=00:00:00~
string  schedule.specialDaySchedules.1.timeSlices.0.endTime=09:00:00~
string  schedule.specialDaySchedules.1.timeSlices.0.colorCode=T1~
object  schedule.specialDaySchedules.1.timeSlices.1={ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }~
string  schedule.specialDaySchedules.1.timeSlices.1.startTime=09:00:00~
string  schedule.specialDaySchedules.1.timeSlices.1.endTime=17:00:00~
string  schedule.specialDaySchedules.1.timeSlices.1.colorCode=T0~
object  schedule.specialDaySchedules.1.timeSlices.2={ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }~
string  schedule.specialDaySchedules.1.timeSlices.2.startTime=17:00:00~
string  schedule.specialDaySchedules.1.timeSlices.2.endTime=24:00:00~
string  schedule.specialDaySchedules.1.timeSlices.2.colorCode=T1~
string  schedule.name=Sample Schedule~
string  schedule.tags=Sample Tags~
string  schedule.description=Sample Description~
string  schedule.objectType=vs_schedule~)


echo '= 3 === -c'

DOTEST(-c,"erty"dnl
,1	0	6	\N	erty)
DOTEST(-c,1dnl
,1	0	3	\N	1)
DOTEST(-c,1.5dnl
,1	0	2	\N	1.5)
DOTEST(-c,truednl
,1	0	1	\N	t)
DOTEST(-c,falsednl
,1	0	1	\N	f)
DOTEST(-c,{"e":1}dnl
,1	0	4	\N	\N
2	1	3	e	1)
DOTEST(-c,{"e":1,"r":5.3,"q":"tyui","t":false}dnl
,1	0	4	\N	\N
2	1	3	e	1
3	1	2	r	5.3
4	1	6	q	tyui
5	1	1	t	f)
DOTEST(-c,[1,2,3,4,5,6]dnl
,1	0	5	\N	\N
2	1	3	0	1
3	1	3	1	2
4	1	3	2	3
5	1	3	3	4
6	1	3	4	5
7	1	3	5	6)
DOTEST(-c,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,1	0	5	\N	\N
2	1	4	0	\N
3	2	3	e	1
4	2	2	r	5.3
5	1	4	1	\N
6	5	3	e	2
7	5	2	r	5.4
8	1	4	2	\N
9	8	3	e	3
10	8	2	r	5.5)
DOTEST(-c,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,1	0	4	\N	\N
2	1	5	r	\N
3	2	4	0	\N
4	3	3	e	1
5	3	2	r	5.3
6	2	4	1	\N
7	6	3	e	2
8	6	2	r	5.4
9	1	1	Y	t)
DOTEST(-c,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,1	0	4	\N	\N
2	1	6	i	II
3	1	6	j	JJ
4	1	6	k	KK
5	1	6	l	LL
6	1	6	Y	yy)
DOTEST(-c,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,1	0	4	\N	\N
2	1	4	schedule	\N
3	2	4	ownerLocRef	\N
4	3	6	refUid	40000000-0000-0000-0000-000000000005
5	3	6	refName	System
6	3	6	refObjectType	location
7	2	5	timeCategorys	\N
8	7	4	0	\N
9	8	6	name	Weekdays
10	8	6	colorCode	T0
11	7	4	1	\N
12	11	6	name	Nights and Weekends
13	11	6	colorCode	T1
14	7	4	2	\N
15	14	6	name	
16	14	6	colorCode	T2
17	7	4	3	\N
18	17	6	name	
19	17	6	colorCode	T3
20	7	4	4	\N
21	20	6	name	
22	20	6	colorCode	T4
23	7	4	5	\N
24	23	6	name	
25	23	6	colorCode	T5
26	7	4	6	\N
27	26	6	name	
28	26	6	colorCode	T6
29	7	4	7	\N
30	29	6	name	
31	29	6	colorCode	T7
32	2	5	weeklySchedules	\N
33	32	4	0	\N
34	33	6	name	Weekly Schedule 1
35	33	5	dailySchedules	\N
36	35	4	0	\N
37	36	6	dayOfWeek	MON
38	36	5	timeSlices	\N
39	38	4	0	\N
40	39	6	startTime	00:00:00
41	39	6	endTime	08:00:00
42	39	6	colorCode	T1
43	38	4	1	\N
44	43	6	startTime	08:00:00
45	43	6	endTime	17:00:00
46	43	6	colorCode	T0
47	38	4	2	\N
48	47	6	startTime	17:00:00
49	47	6	endTime	24:00:00
50	47	6	colorCode	T1
51	35	4	1	\N
52	51	6	dayOfWeek	TUE
53	51	5	timeSlices	\N
54	53	4	0	\N
55	54	6	startTime	00:00:00
56	54	6	endTime	08:00:00
57	54	6	colorCode	T1
58	53	4	1	\N
59	58	6	startTime	08:00:00
60	58	6	endTime	17:00:00
61	58	6	colorCode	T0
62	53	4	2	\N
63	62	6	startTime	17:00:00
64	62	6	endTime	24:00:00
65	62	6	colorCode	T1
66	35	4	2	\N
67	66	6	dayOfWeek	WED
68	66	5	timeSlices	\N
69	68	4	0	\N
70	69	6	startTime	00:00:00
71	69	6	endTime	08:00:00
72	69	6	colorCode	T1
73	68	4	1	\N
74	73	6	startTime	08:00:00
75	73	6	endTime	17:00:00
76	73	6	colorCode	T0
77	68	4	2	\N
78	77	6	startTime	17:00:00
79	77	6	endTime	24:00:00
80	77	6	colorCode	T1
81	35	4	3	\N
82	81	6	dayOfWeek	THU
83	81	5	timeSlices	\N
84	83	4	0	\N
85	84	6	startTime	00:00:00
86	84	6	endTime	08:00:00
87	84	6	colorCode	T1
88	83	4	1	\N
89	88	6	startTime	08:00:00
90	88	6	endTime	17:00:00
91	88	6	colorCode	T0
92	83	4	2	\N
93	92	6	startTime	17:00:00
94	92	6	endTime	24:00:00
95	92	6	colorCode	T1
96	35	4	4	\N
97	96	6	dayOfWeek	FRI
98	96	5	timeSlices	\N
99	98	4	0	\N
100	99	6	startTime	00:00:00
101	99	6	endTime	08:00:00
102	99	6	colorCode	T1
103	98	4	1	\N
104	103	6	startTime	08:00:00
105	103	6	endTime	17:00:00
106	103	6	colorCode	T0
107	98	4	2	\N
108	107	6	startTime	17:00:00
109	107	6	endTime	24:00:00
110	107	6	colorCode	T1
111	35	4	5	\N
112	111	6	dayOfWeek	SAT
113	111	5	timeSlices	\N
114	113	4	0	\N
115	114	6	startTime	00:00:00
116	114	6	endTime	24:00:00
117	114	6	colorCode	T1
118	35	4	6	\N
119	118	6	dayOfWeek	SUN
120	118	5	timeSlices	\N
121	120	4	0	\N
122	121	6	startTime	00:00:00
123	121	6	endTime	24:00:00
124	121	6	colorCode	T1
125	32	4	1	\N
126	125	6	name	Weekly Schedule 2
127	125	6	startDate	07-01-2011
128	125	5	dailySchedules	\N
129	128	4	0	\N
130	129	6	dayOfWeek	MON
131	129	5	timeSlices	\N
132	131	4	0	\N
133	132	6	startTime	00:00:00
134	132	6	endTime	08:00:00
135	132	6	colorCode	T1
136	131	4	1	\N
137	136	6	startTime	08:00:00
138	136	6	endTime	17:00:00
139	136	6	colorCode	T0
140	131	4	2	\N
141	140	6	startTime	17:00:00
142	140	6	endTime	24:00:00
143	140	6	colorCode	T1
144	128	4	1	\N
145	144	6	dayOfWeek	TUE
146	144	5	timeSlices	\N
147	146	4	0	\N
148	147	6	startTime	00:00:00
149	147	6	endTime	08:00:00
150	147	6	colorCode	T1
151	146	4	1	\N
152	151	6	startTime	08:00:00
153	151	6	endTime	17:00:00
154	151	6	colorCode	T0
155	146	4	2	\N
156	155	6	startTime	17:00:00
157	155	6	endTime	24:00:00
158	155	6	colorCode	T1
159	128	4	2	\N
160	159	6	dayOfWeek	WED
161	159	5	timeSlices	\N
162	161	4	0	\N
163	162	6	startTime	00:00:00
164	162	6	endTime	08:00:00
165	162	6	colorCode	T1
166	161	4	1	\N
167	166	6	startTime	08:00:00
168	166	6	endTime	17:00:00
169	166	6	colorCode	T0
170	161	4	2	\N
171	170	6	startTime	17:00:00
172	170	6	endTime	24:00:00
173	170	6	colorCode	T1
174	128	4	3	\N
175	174	6	dayOfWeek	THU
176	174	5	timeSlices	\N
177	176	4	0	\N
178	177	6	startTime	00:00:00
179	177	6	endTime	08:00:00
180	177	6	colorCode	T1
181	176	4	1	\N
182	181	6	startTime	08:00:00
183	181	6	endTime	17:00:00
184	181	6	colorCode	T0
185	176	4	2	\N
186	185	6	startTime	17:00:00
187	185	6	endTime	24:00:00
188	185	6	colorCode	T1
189	128	4	4	\N
190	189	6	dayOfWeek	FRI
191	189	5	timeSlices	\N
192	191	4	0	\N
193	192	6	startTime	00:00:00
194	192	6	endTime	08:00:00
195	192	6	colorCode	T1
196	191	4	1	\N
197	196	6	startTime	08:00:00
198	196	6	endTime	17:00:00
199	196	6	colorCode	T0
200	191	4	2	\N
201	200	6	startTime	17:00:00
202	200	6	endTime	24:00:00
203	200	6	colorCode	T1
204	128	4	5	\N
205	204	6	dayOfWeek	SAT
206	204	5	timeSlices	\N
207	206	4	0	\N
208	207	6	startTime	00:00:00
209	207	6	endTime	24:00:00
210	207	6	colorCode	T1
211	128	4	6	\N
212	211	6	dayOfWeek	SUN
213	211	5	timeSlices	\N
214	213	4	0	\N
215	214	6	startTime	00:00:00
216	214	6	endTime	24:00:00
217	214	6	colorCode	T1
218	2	5	specialDaySchedules	\N
219	218	4	0	\N
220	219	6	name	Special Day 1
221	219	6	startDate	07-04-2011
222	219	6	endDate	07-04-2011
223	219	5	timeSlices	\N
224	223	4	0	\N
225	224	6	startTime	00:00:00
226	224	6	endTime	09:00:00
227	224	6	colorCode	T1
228	223	4	1	\N
229	228	6	startTime	09:00:00
230	228	6	endTime	17:00:00
231	228	6	colorCode	T0
232	223	4	2	\N
233	232	6	startTime	17:00:00
234	232	6	endTime	24:00:00
235	232	6	colorCode	T1
236	218	4	1	\N
237	236	6	name	Special Days 2 
238	236	6	startDate	12-24-2011
239	236	6	endDate	12-26-2011
240	236	5	timeSlices	\N
241	240	4	0	\N
242	241	6	startTime	00:00:00
243	241	6	endTime	09:00:00
244	241	6	colorCode	T1
245	240	4	1	\N
246	245	6	startTime	09:00:00
247	245	6	endTime	17:00:00
248	245	6	colorCode	T0
249	240	4	2	\N
250	249	6	startTime	17:00:00
251	249	6	endTime	24:00:00
252	249	6	colorCode	T1
253	2	6	name	Sample Schedule
254	2	6	tags	Sample Tags
255	2	6	description	Sample Description
256	2	6	objectType	vs_schedule)


echo '= 4 === -cc'

DOTEST(-cc,"erty"dnl
,1	6	\N	erty)
DOTEST(-cc,1dnl
,1	3	\N	1)
DOTEST(-cc,1.5dnl
,1	2	\N	1.5)
DOTEST(-cc,truednl
,1	1	\N	t)
DOTEST(-cc,falsednl
,1	1	\N	f)
DOTEST(-cc,{"e":1}dnl
,1	4	\N	\N
2	3	e	1)
DOTEST(-cc,{"e":1,"r":5.3,"q":"tyui","t":true}dnl
,1	4	\N	\N
2	3	e	1
3	2	r	5.3
4	6	q	tyui
5	1	t	t)
DOTEST(-cc,[1,2,3,4,5,6]dnl
,1	5	\N	\N
2	3	0	1
3	3	1	2
4	3	2	3
5	3	3	4
6	3	4	5
7	3	5	6)
DOTEST(-cc,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,1	5	\N	\N
2	4	0	\N
3	3	0.e	1
4	2	0.r	5.3
5	4	1	\N
6	3	1.e	2
7	2	1.r	5.4
8	4	2	\N
9	3	2.e	3
10	2	2.r	5.5)
DOTEST(-cc,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,1	4	\N	\N
2	5	r	\N
3	4	r.0	\N
4	3	r.0.e	1
5	2	r.0.r	5.3
6	4	r.1	\N
7	3	r.1.e	2
8	2	r.1.r	5.4
9	1	Y	t)
DOTEST(-cc,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,1	4	\N	\N
2	6	i	II
3	6	j	JJ
4	6	k	KK
5	6	l	LL
6	6	Y	yy)
DOTEST(-cc,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,1	4	\N	\N
2	4	schedule	\N
3	4	schedule.ownerLocRef	\N
4	6	schedule.ownerLocRef.refUid	40000000-0000-0000-0000-000000000005
5	6	schedule.ownerLocRef.refName	System
6	6	schedule.ownerLocRef.refObjectType	location
7	5	schedule.timeCategorys	\N
8	4	schedule.timeCategorys.0	\N
9	6	schedule.timeCategorys.0.name	Weekdays
10	6	schedule.timeCategorys.0.colorCode	T0
11	4	schedule.timeCategorys.1	\N
12	6	schedule.timeCategorys.1.name	Nights and Weekends
13	6	schedule.timeCategorys.1.colorCode	T1
14	4	schedule.timeCategorys.2	\N
15	6	schedule.timeCategorys.2.name	
16	6	schedule.timeCategorys.2.colorCode	T2
17	4	schedule.timeCategorys.3	\N
18	6	schedule.timeCategorys.3.name	
19	6	schedule.timeCategorys.3.colorCode	T3
20	4	schedule.timeCategorys.4	\N
21	6	schedule.timeCategorys.4.name	
22	6	schedule.timeCategorys.4.colorCode	T4
23	4	schedule.timeCategorys.5	\N
24	6	schedule.timeCategorys.5.name	
25	6	schedule.timeCategorys.5.colorCode	T5
26	4	schedule.timeCategorys.6	\N
27	6	schedule.timeCategorys.6.name	
28	6	schedule.timeCategorys.6.colorCode	T6
29	4	schedule.timeCategorys.7	\N
30	6	schedule.timeCategorys.7.name	
31	6	schedule.timeCategorys.7.colorCode	T7
32	5	schedule.weeklySchedules	\N
33	4	schedule.weeklySchedules.0	\N
34	6	schedule.weeklySchedules.0.name	Weekly Schedule 1
35	5	schedule.weeklySchedules.0.dailySchedules	\N
36	4	schedule.weeklySchedules.0.dailySchedules.0	\N
37	6	schedule.weeklySchedules.0.dailySchedules.0.dayOfWeek	MON
38	5	schedule.weeklySchedules.0.dailySchedules.0.timeSlices	\N
39	4	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0	\N
40	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.startTime	00:00:00
41	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.endTime	08:00:00
42	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.colorCode	T1
43	4	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1	\N
44	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.startTime	08:00:00
45	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.endTime	17:00:00
46	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.colorCode	T0
47	4	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2	\N
48	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.startTime	17:00:00
49	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.endTime	24:00:00
50	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.colorCode	T1
51	4	schedule.weeklySchedules.0.dailySchedules.1	\N
52	6	schedule.weeklySchedules.0.dailySchedules.1.dayOfWeek	TUE
53	5	schedule.weeklySchedules.0.dailySchedules.1.timeSlices	\N
54	4	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0	\N
55	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.startTime	00:00:00
56	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.endTime	08:00:00
57	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.colorCode	T1
58	4	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1	\N
59	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.startTime	08:00:00
60	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.endTime	17:00:00
61	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.colorCode	T0
62	4	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2	\N
63	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.startTime	17:00:00
64	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.endTime	24:00:00
65	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.colorCode	T1
66	4	schedule.weeklySchedules.0.dailySchedules.2	\N
67	6	schedule.weeklySchedules.0.dailySchedules.2.dayOfWeek	WED
68	5	schedule.weeklySchedules.0.dailySchedules.2.timeSlices	\N
69	4	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0	\N
70	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.startTime	00:00:00
71	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.endTime	08:00:00
72	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.colorCode	T1
73	4	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1	\N
74	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.startTime	08:00:00
75	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.endTime	17:00:00
76	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.colorCode	T0
77	4	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2	\N
78	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.startTime	17:00:00
79	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.endTime	24:00:00
80	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.colorCode	T1
81	4	schedule.weeklySchedules.0.dailySchedules.3	\N
82	6	schedule.weeklySchedules.0.dailySchedules.3.dayOfWeek	THU
83	5	schedule.weeklySchedules.0.dailySchedules.3.timeSlices	\N
84	4	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0	\N
85	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.startTime	00:00:00
86	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.endTime	08:00:00
87	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.colorCode	T1
88	4	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1	\N
89	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.startTime	08:00:00
90	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.endTime	17:00:00
91	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.colorCode	T0
92	4	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2	\N
93	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.startTime	17:00:00
94	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.endTime	24:00:00
95	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.colorCode	T1
96	4	schedule.weeklySchedules.0.dailySchedules.4	\N
97	6	schedule.weeklySchedules.0.dailySchedules.4.dayOfWeek	FRI
98	5	schedule.weeklySchedules.0.dailySchedules.4.timeSlices	\N
99	4	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0	\N
100	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.startTime	00:00:00
101	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.endTime	08:00:00
102	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.colorCode	T1
103	4	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1	\N
104	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.startTime	08:00:00
105	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.endTime	17:00:00
106	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.colorCode	T0
107	4	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2	\N
108	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.startTime	17:00:00
109	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.endTime	24:00:00
110	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.colorCode	T1
111	4	schedule.weeklySchedules.0.dailySchedules.5	\N
112	6	schedule.weeklySchedules.0.dailySchedules.5.dayOfWeek	SAT
113	5	schedule.weeklySchedules.0.dailySchedules.5.timeSlices	\N
114	4	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0	\N
115	6	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.startTime	00:00:00
116	6	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.endTime	24:00:00
117	6	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.colorCode	T1
118	4	schedule.weeklySchedules.0.dailySchedules.6	\N
119	6	schedule.weeklySchedules.0.dailySchedules.6.dayOfWeek	SUN
120	5	schedule.weeklySchedules.0.dailySchedules.6.timeSlices	\N
121	4	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0	\N
122	6	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.startTime	00:00:00
123	6	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.endTime	24:00:00
124	6	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.colorCode	T1
125	4	schedule.weeklySchedules.1	\N
126	6	schedule.weeklySchedules.1.name	Weekly Schedule 2
127	6	schedule.weeklySchedules.1.startDate	07-01-2011
128	5	schedule.weeklySchedules.1.dailySchedules	\N
129	4	schedule.weeklySchedules.1.dailySchedules.0	\N
130	6	schedule.weeklySchedules.1.dailySchedules.0.dayOfWeek	MON
131	5	schedule.weeklySchedules.1.dailySchedules.0.timeSlices	\N
132	4	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0	\N
133	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.startTime	00:00:00
134	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.endTime	08:00:00
135	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.colorCode	T1
136	4	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1	\N
137	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.startTime	08:00:00
138	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.endTime	17:00:00
139	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.colorCode	T0
140	4	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2	\N
141	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.startTime	17:00:00
142	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.endTime	24:00:00
143	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.colorCode	T1
144	4	schedule.weeklySchedules.1.dailySchedules.1	\N
145	6	schedule.weeklySchedules.1.dailySchedules.1.dayOfWeek	TUE
146	5	schedule.weeklySchedules.1.dailySchedules.1.timeSlices	\N
147	4	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0	\N
148	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.startTime	00:00:00
149	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.endTime	08:00:00
150	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.colorCode	T1
151	4	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1	\N
152	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.startTime	08:00:00
153	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.endTime	17:00:00
154	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.colorCode	T0
155	4	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2	\N
156	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.startTime	17:00:00
157	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.endTime	24:00:00
158	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.colorCode	T1
159	4	schedule.weeklySchedules.1.dailySchedules.2	\N
160	6	schedule.weeklySchedules.1.dailySchedules.2.dayOfWeek	WED
161	5	schedule.weeklySchedules.1.dailySchedules.2.timeSlices	\N
162	4	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0	\N
163	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.startTime	00:00:00
164	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.endTime	08:00:00
165	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.colorCode	T1
166	4	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1	\N
167	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.startTime	08:00:00
168	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.endTime	17:00:00
169	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.colorCode	T0
170	4	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2	\N
171	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.startTime	17:00:00
172	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.endTime	24:00:00
173	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.colorCode	T1
174	4	schedule.weeklySchedules.1.dailySchedules.3	\N
175	6	schedule.weeklySchedules.1.dailySchedules.3.dayOfWeek	THU
176	5	schedule.weeklySchedules.1.dailySchedules.3.timeSlices	\N
177	4	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0	\N
178	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.startTime	00:00:00
179	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.endTime	08:00:00
180	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.colorCode	T1
181	4	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1	\N
182	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.startTime	08:00:00
183	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.endTime	17:00:00
184	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.colorCode	T0
185	4	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2	\N
186	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.startTime	17:00:00
187	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.endTime	24:00:00
188	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.colorCode	T1
189	4	schedule.weeklySchedules.1.dailySchedules.4	\N
190	6	schedule.weeklySchedules.1.dailySchedules.4.dayOfWeek	FRI
191	5	schedule.weeklySchedules.1.dailySchedules.4.timeSlices	\N
192	4	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0	\N
193	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.startTime	00:00:00
194	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.endTime	08:00:00
195	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.colorCode	T1
196	4	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1	\N
197	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.startTime	08:00:00
198	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.endTime	17:00:00
199	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.colorCode	T0
200	4	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2	\N
201	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.startTime	17:00:00
202	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.endTime	24:00:00
203	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.colorCode	T1
204	4	schedule.weeklySchedules.1.dailySchedules.5	\N
205	6	schedule.weeklySchedules.1.dailySchedules.5.dayOfWeek	SAT
206	5	schedule.weeklySchedules.1.dailySchedules.5.timeSlices	\N
207	4	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0	\N
208	6	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.startTime	00:00:00
209	6	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.endTime	24:00:00
210	6	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.colorCode	T1
211	4	schedule.weeklySchedules.1.dailySchedules.6	\N
212	6	schedule.weeklySchedules.1.dailySchedules.6.dayOfWeek	SUN
213	5	schedule.weeklySchedules.1.dailySchedules.6.timeSlices	\N
214	4	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0	\N
215	6	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.startTime	00:00:00
216	6	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.endTime	24:00:00
217	6	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.colorCode	T1
218	5	schedule.specialDaySchedules	\N
219	4	schedule.specialDaySchedules.0	\N
220	6	schedule.specialDaySchedules.0.name	Special Day 1
221	6	schedule.specialDaySchedules.0.startDate	07-04-2011
222	6	schedule.specialDaySchedules.0.endDate	07-04-2011
223	5	schedule.specialDaySchedules.0.timeSlices	\N
224	4	schedule.specialDaySchedules.0.timeSlices.0	\N
225	6	schedule.specialDaySchedules.0.timeSlices.0.startTime	00:00:00
226	6	schedule.specialDaySchedules.0.timeSlices.0.endTime	09:00:00
227	6	schedule.specialDaySchedules.0.timeSlices.0.colorCode	T1
228	4	schedule.specialDaySchedules.0.timeSlices.1	\N
229	6	schedule.specialDaySchedules.0.timeSlices.1.startTime	09:00:00
230	6	schedule.specialDaySchedules.0.timeSlices.1.endTime	17:00:00
231	6	schedule.specialDaySchedules.0.timeSlices.1.colorCode	T0
232	4	schedule.specialDaySchedules.0.timeSlices.2	\N
233	6	schedule.specialDaySchedules.0.timeSlices.2.startTime	17:00:00
234	6	schedule.specialDaySchedules.0.timeSlices.2.endTime	24:00:00
235	6	schedule.specialDaySchedules.0.timeSlices.2.colorCode	T1
236	4	schedule.specialDaySchedules.1	\N
237	6	schedule.specialDaySchedules.1.name	Special Days 2 
238	6	schedule.specialDaySchedules.1.startDate	12-24-2011
239	6	schedule.specialDaySchedules.1.endDate	12-26-2011
240	5	schedule.specialDaySchedules.1.timeSlices	\N
241	4	schedule.specialDaySchedules.1.timeSlices.0	\N
242	6	schedule.specialDaySchedules.1.timeSlices.0.startTime	00:00:00
243	6	schedule.specialDaySchedules.1.timeSlices.0.endTime	09:00:00
244	6	schedule.specialDaySchedules.1.timeSlices.0.colorCode	T1
245	4	schedule.specialDaySchedules.1.timeSlices.1	\N
246	6	schedule.specialDaySchedules.1.timeSlices.1.startTime	09:00:00
247	6	schedule.specialDaySchedules.1.timeSlices.1.endTime	17:00:00
248	6	schedule.specialDaySchedules.1.timeSlices.1.colorCode	T0
249	4	schedule.specialDaySchedules.1.timeSlices.2	\N
250	6	schedule.specialDaySchedules.1.timeSlices.2.startTime	17:00:00
251	6	schedule.specialDaySchedules.1.timeSlices.2.endTime	24:00:00
252	6	schedule.specialDaySchedules.1.timeSlices.2.colorCode	T1
253	6	schedule.name	Sample Schedule
254	6	schedule.tags	Sample Tags
255	6	schedule.description	Sample Description
256	6	schedule.objectType	vs_schedule)


echo '= 5 === -ccc'

DOTEST(-ccc,"erty"dnl
,1	6	\N	erty)
DOTEST(-ccc,1dnl
,1	3	\N	1)
DOTEST(-ccc,1.5dnl
,1	2	\N	1.5)
DOTEST(-ccc,truednl
,1	1	\N	t)
DOTEST(-ccc,falsednl
,1	1	\N	f)
DOTEST(-ccc,{"e":1}dnl
,1	4	\N	\N
2	3	{"e"}	1)
DOTEST(-ccc,{"e":1,"r":5.3,"q":"tyui","t":true}dnl
,1	4	\N	\N
2	3	{"e"}	1
3	2	{"r"}	5.3
4	6	{"q"}	tyui
5	1	{"t"}	t)
DOTEST(-ccc,[1,2,3,4,5,6]dnl
,1	5	\N	\N
2	3	{"0"}	1
3	3	{"1"}	2
4	3	{"2"}	3
5	3	{"3"}	4
6	3	{"4"}	5
7	3	{"5"}	6)
DOTEST(-ccc,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,1	5	\N	\N
2	4	{"0"}	\N
3	3	{"0","e"}	1
4	2	{"0","r"}	5.3
5	4	{"1"}	\N
6	3	{"1","e"}	2
7	2	{"1","r"}	5.4
8	4	{"2"}	\N
9	3	{"2","e"}	3
10	2	{"2","r"}	5.5)
DOTEST(-ccc,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,1	4	\N	\N
2	5	{"r"}	\N
3	4	{"r","0"}	\N
4	3	{"r","0","e"}	1
5	2	{"r","0","r"}	5.3
6	4	{"r","1"}	\N
7	3	{"r","1","e"}	2
8	2	{"r","1","r"}	5.4
9	1	{"Y"}	t)
DOTEST(-ccc,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,1	4	\N	\N
2	6	{"i"}	II
3	6	{"j"}	JJ
4	6	{"k"}	KK
5	6	{"l"}	LL
6	6	{"Y"}	yy)
DOTEST(-ccc,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,1	4	\N	\N
2	4	{"schedule"}	\N
3	4	{"schedule","ownerLocRef"}	\N
4	6	{"schedule","ownerLocRef","refUid"}	40000000-0000-0000-0000-000000000005
5	6	{"schedule","ownerLocRef","refName"}	System
6	6	{"schedule","ownerLocRef","refObjectType"}	location
7	5	{"schedule","timeCategorys"}	\N
8	4	{"schedule","timeCategorys","0"}	\N
9	6	{"schedule","timeCategorys","0","name"}	Weekdays
10	6	{"schedule","timeCategorys","0","colorCode"}	T0
11	4	{"schedule","timeCategorys","1"}	\N
12	6	{"schedule","timeCategorys","1","name"}	Nights and Weekends
13	6	{"schedule","timeCategorys","1","colorCode"}	T1
14	4	{"schedule","timeCategorys","2"}	\N
15	6	{"schedule","timeCategorys","2","name"}	
16	6	{"schedule","timeCategorys","2","colorCode"}	T2
17	4	{"schedule","timeCategorys","3"}	\N
18	6	{"schedule","timeCategorys","3","name"}	
19	6	{"schedule","timeCategorys","3","colorCode"}	T3
20	4	{"schedule","timeCategorys","4"}	\N
21	6	{"schedule","timeCategorys","4","name"}	
22	6	{"schedule","timeCategorys","4","colorCode"}	T4
23	4	{"schedule","timeCategorys","5"}	\N
24	6	{"schedule","timeCategorys","5","name"}	
25	6	{"schedule","timeCategorys","5","colorCode"}	T5
26	4	{"schedule","timeCategorys","6"}	\N
27	6	{"schedule","timeCategorys","6","name"}	
28	6	{"schedule","timeCategorys","6","colorCode"}	T6
29	4	{"schedule","timeCategorys","7"}	\N
30	6	{"schedule","timeCategorys","7","name"}	
31	6	{"schedule","timeCategorys","7","colorCode"}	T7
32	5	{"schedule","weeklySchedules"}	\N
33	4	{"schedule","weeklySchedules","0"}	\N
34	6	{"schedule","weeklySchedules","0","name"}	Weekly Schedule 1
35	5	{"schedule","weeklySchedules","0","dailySchedules"}	\N
36	4	{"schedule","weeklySchedules","0","dailySchedules","0"}	\N
37	6	{"schedule","weeklySchedules","0","dailySchedules","0","dayOfWeek"}	MON
38	5	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices"}	\N
39	4	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0"}	\N
40	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0","startTime"}	00:00:00
41	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0","endTime"}	08:00:00
42	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0","colorCode"}	T1
43	4	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1"}	\N
44	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1","startTime"}	08:00:00
45	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1","endTime"}	17:00:00
46	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1","colorCode"}	T0
47	4	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2"}	\N
48	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2","startTime"}	17:00:00
49	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2","endTime"}	24:00:00
50	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2","colorCode"}	T1
51	4	{"schedule","weeklySchedules","0","dailySchedules","1"}	\N
52	6	{"schedule","weeklySchedules","0","dailySchedules","1","dayOfWeek"}	TUE
53	5	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices"}	\N
54	4	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0"}	\N
55	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0","startTime"}	00:00:00
56	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0","endTime"}	08:00:00
57	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0","colorCode"}	T1
58	4	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1"}	\N
59	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1","startTime"}	08:00:00
60	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1","endTime"}	17:00:00
61	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1","colorCode"}	T0
62	4	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2"}	\N
63	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2","startTime"}	17:00:00
64	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2","endTime"}	24:00:00
65	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2","colorCode"}	T1
66	4	{"schedule","weeklySchedules","0","dailySchedules","2"}	\N
67	6	{"schedule","weeklySchedules","0","dailySchedules","2","dayOfWeek"}	WED
68	5	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices"}	\N
69	4	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0"}	\N
70	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0","startTime"}	00:00:00
71	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0","endTime"}	08:00:00
72	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0","colorCode"}	T1
73	4	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1"}	\N
74	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1","startTime"}	08:00:00
75	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1","endTime"}	17:00:00
76	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1","colorCode"}	T0
77	4	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2"}	\N
78	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2","startTime"}	17:00:00
79	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2","endTime"}	24:00:00
80	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2","colorCode"}	T1
81	4	{"schedule","weeklySchedules","0","dailySchedules","3"}	\N
82	6	{"schedule","weeklySchedules","0","dailySchedules","3","dayOfWeek"}	THU
83	5	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices"}	\N
84	4	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0"}	\N
85	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0","startTime"}	00:00:00
86	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0","endTime"}	08:00:00
87	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0","colorCode"}	T1
88	4	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1"}	\N
89	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1","startTime"}	08:00:00
90	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1","endTime"}	17:00:00
91	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1","colorCode"}	T0
92	4	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2"}	\N
93	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2","startTime"}	17:00:00
94	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2","endTime"}	24:00:00
95	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2","colorCode"}	T1
96	4	{"schedule","weeklySchedules","0","dailySchedules","4"}	\N
97	6	{"schedule","weeklySchedules","0","dailySchedules","4","dayOfWeek"}	FRI
98	5	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices"}	\N
99	4	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0"}	\N
100	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0","startTime"}	00:00:00
101	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0","endTime"}	08:00:00
102	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0","colorCode"}	T1
103	4	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1"}	\N
104	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1","startTime"}	08:00:00
105	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1","endTime"}	17:00:00
106	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1","colorCode"}	T0
107	4	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2"}	\N
108	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2","startTime"}	17:00:00
109	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2","endTime"}	24:00:00
110	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2","colorCode"}	T1
111	4	{"schedule","weeklySchedules","0","dailySchedules","5"}	\N
112	6	{"schedule","weeklySchedules","0","dailySchedules","5","dayOfWeek"}	SAT
113	5	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices"}	\N
114	4	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0"}	\N
115	6	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0","startTime"}	00:00:00
116	6	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0","endTime"}	24:00:00
117	6	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0","colorCode"}	T1
118	4	{"schedule","weeklySchedules","0","dailySchedules","6"}	\N
119	6	{"schedule","weeklySchedules","0","dailySchedules","6","dayOfWeek"}	SUN
120	5	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices"}	\N
121	4	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0"}	\N
122	6	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0","startTime"}	00:00:00
123	6	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0","endTime"}	24:00:00
124	6	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0","colorCode"}	T1
125	4	{"schedule","weeklySchedules","1"}	\N
126	6	{"schedule","weeklySchedules","1","name"}	Weekly Schedule 2
127	6	{"schedule","weeklySchedules","1","startDate"}	07-01-2011
128	5	{"schedule","weeklySchedules","1","dailySchedules"}	\N
129	4	{"schedule","weeklySchedules","1","dailySchedules","0"}	\N
130	6	{"schedule","weeklySchedules","1","dailySchedules","0","dayOfWeek"}	MON
131	5	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices"}	\N
132	4	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0"}	\N
133	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0","startTime"}	00:00:00
134	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0","endTime"}	08:00:00
135	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0","colorCode"}	T1
136	4	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1"}	\N
137	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1","startTime"}	08:00:00
138	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1","endTime"}	17:00:00
139	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1","colorCode"}	T0
140	4	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2"}	\N
141	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2","startTime"}	17:00:00
142	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2","endTime"}	24:00:00
143	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2","colorCode"}	T1
144	4	{"schedule","weeklySchedules","1","dailySchedules","1"}	\N
145	6	{"schedule","weeklySchedules","1","dailySchedules","1","dayOfWeek"}	TUE
146	5	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices"}	\N
147	4	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0"}	\N
148	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0","startTime"}	00:00:00
149	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0","endTime"}	08:00:00
150	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0","colorCode"}	T1
151	4	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1"}	\N
152	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1","startTime"}	08:00:00
153	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1","endTime"}	17:00:00
154	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1","colorCode"}	T0
155	4	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2"}	\N
156	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2","startTime"}	17:00:00
157	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2","endTime"}	24:00:00
158	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2","colorCode"}	T1
159	4	{"schedule","weeklySchedules","1","dailySchedules","2"}	\N
160	6	{"schedule","weeklySchedules","1","dailySchedules","2","dayOfWeek"}	WED
161	5	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices"}	\N
162	4	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0"}	\N
163	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0","startTime"}	00:00:00
164	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0","endTime"}	08:00:00
165	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0","colorCode"}	T1
166	4	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1"}	\N
167	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1","startTime"}	08:00:00
168	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1","endTime"}	17:00:00
169	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1","colorCode"}	T0
170	4	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2"}	\N
171	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2","startTime"}	17:00:00
172	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2","endTime"}	24:00:00
173	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2","colorCode"}	T1
174	4	{"schedule","weeklySchedules","1","dailySchedules","3"}	\N
175	6	{"schedule","weeklySchedules","1","dailySchedules","3","dayOfWeek"}	THU
176	5	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices"}	\N
177	4	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0"}	\N
178	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0","startTime"}	00:00:00
179	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0","endTime"}	08:00:00
180	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0","colorCode"}	T1
181	4	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1"}	\N
182	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1","startTime"}	08:00:00
183	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1","endTime"}	17:00:00
184	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1","colorCode"}	T0
185	4	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2"}	\N
186	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2","startTime"}	17:00:00
187	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2","endTime"}	24:00:00
188	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2","colorCode"}	T1
189	4	{"schedule","weeklySchedules","1","dailySchedules","4"}	\N
190	6	{"schedule","weeklySchedules","1","dailySchedules","4","dayOfWeek"}	FRI
191	5	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices"}	\N
192	4	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0"}	\N
193	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0","startTime"}	00:00:00
194	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0","endTime"}	08:00:00
195	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0","colorCode"}	T1
196	4	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1"}	\N
197	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1","startTime"}	08:00:00
198	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1","endTime"}	17:00:00
199	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1","colorCode"}	T0
200	4	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2"}	\N
201	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2","startTime"}	17:00:00
202	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2","endTime"}	24:00:00
203	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2","colorCode"}	T1
204	4	{"schedule","weeklySchedules","1","dailySchedules","5"}	\N
205	6	{"schedule","weeklySchedules","1","dailySchedules","5","dayOfWeek"}	SAT
206	5	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices"}	\N
207	4	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0"}	\N
208	6	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0","startTime"}	00:00:00
209	6	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0","endTime"}	24:00:00
210	6	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0","colorCode"}	T1
211	4	{"schedule","weeklySchedules","1","dailySchedules","6"}	\N
212	6	{"schedule","weeklySchedules","1","dailySchedules","6","dayOfWeek"}	SUN
213	5	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices"}	\N
214	4	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0"}	\N
215	6	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0","startTime"}	00:00:00
216	6	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0","endTime"}	24:00:00
217	6	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0","colorCode"}	T1
218	5	{"schedule","specialDaySchedules"}	\N
219	4	{"schedule","specialDaySchedules","0"}	\N
220	6	{"schedule","specialDaySchedules","0","name"}	Special Day 1
221	6	{"schedule","specialDaySchedules","0","startDate"}	07-04-2011
222	6	{"schedule","specialDaySchedules","0","endDate"}	07-04-2011
223	5	{"schedule","specialDaySchedules","0","timeSlices"}	\N
224	4	{"schedule","specialDaySchedules","0","timeSlices","0"}	\N
225	6	{"schedule","specialDaySchedules","0","timeSlices","0","startTime"}	00:00:00
226	6	{"schedule","specialDaySchedules","0","timeSlices","0","endTime"}	09:00:00
227	6	{"schedule","specialDaySchedules","0","timeSlices","0","colorCode"}	T1
228	4	{"schedule","specialDaySchedules","0","timeSlices","1"}	\N
229	6	{"schedule","specialDaySchedules","0","timeSlices","1","startTime"}	09:00:00
230	6	{"schedule","specialDaySchedules","0","timeSlices","1","endTime"}	17:00:00
231	6	{"schedule","specialDaySchedules","0","timeSlices","1","colorCode"}	T0
232	4	{"schedule","specialDaySchedules","0","timeSlices","2"}	\N
233	6	{"schedule","specialDaySchedules","0","timeSlices","2","startTime"}	17:00:00
234	6	{"schedule","specialDaySchedules","0","timeSlices","2","endTime"}	24:00:00
235	6	{"schedule","specialDaySchedules","0","timeSlices","2","colorCode"}	T1
236	4	{"schedule","specialDaySchedules","1"}	\N
237	6	{"schedule","specialDaySchedules","1","name"}	Special Days 2 
238	6	{"schedule","specialDaySchedules","1","startDate"}	12-24-2011
239	6	{"schedule","specialDaySchedules","1","endDate"}	12-26-2011
240	5	{"schedule","specialDaySchedules","1","timeSlices"}	\N
241	4	{"schedule","specialDaySchedules","1","timeSlices","0"}	\N
242	6	{"schedule","specialDaySchedules","1","timeSlices","0","startTime"}	00:00:00
243	6	{"schedule","specialDaySchedules","1","timeSlices","0","endTime"}	09:00:00
244	6	{"schedule","specialDaySchedules","1","timeSlices","0","colorCode"}	T1
245	4	{"schedule","specialDaySchedules","1","timeSlices","1"}	\N
246	6	{"schedule","specialDaySchedules","1","timeSlices","1","startTime"}	09:00:00
247	6	{"schedule","specialDaySchedules","1","timeSlices","1","endTime"}	17:00:00
248	6	{"schedule","specialDaySchedules","1","timeSlices","1","colorCode"}	T0
249	4	{"schedule","specialDaySchedules","1","timeSlices","2"}	\N
250	6	{"schedule","specialDaySchedules","1","timeSlices","2","startTime"}	17:00:00
251	6	{"schedule","specialDaySchedules","1","timeSlices","2","endTime"}	24:00:00
252	6	{"schedule","specialDaySchedules","1","timeSlices","2","colorCode"}	T1
253	6	{"schedule","name"}	Sample Schedule
254	6	{"schedule","tags"}	Sample Tags
255	6	{"schedule","description"}	Sample Description
256	6	{"schedule","objectType"}	vs_schedule)


echo '= 6 === -cD'

DOTEST(-cD,"erty"dnl
,1	0	6	\N	erty)
DOTEST(-cD,1dnl
,1	0	3	\N	1)
DOTEST(-cD,1.5dnl
,1	0	2	\N	1.5)
DOTEST(-cD,truednl
,1	0	1	\N	t)
DOTEST(-cD,falsednl
,1	0	1	\N	f)
DOTEST(-cD,{"e":1}dnl
,1	0	4	\N	{ "e": 1 }
2	1	3	e	1)
DOTEST(-cD,{"e":1,"r":5.3,"q":"tyui","t":true}dnl
,1	0	4	\N	{ "e": 1, "r": 5.3, "q": "tyui", "t": true }
2	1	3	e	1
3	1	2	r	5.3
4	1	6	q	tyui
5	1	1	t	t)
DOTEST(-cD,[1,2,3,4,5,6]dnl
,1	0	5	\N	[ 1, 2, 3, 4, 5, 6 ]
2	1	3	0	1
3	1	3	1	2
4	1	3	2	3
5	1	3	3	4
6	1	3	4	5
7	1	3	5	6)
DOTEST(-cD,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,1	0	5	\N	[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 }, { "e": 3, "r": 5.5 } ]
2	1	4	0	{ "e": 1, "r": 5.3 }
3	2	3	e	1
4	2	2	r	5.3
5	1	4	1	{ "e": 2, "r": 5.4 }
6	5	3	e	2
7	5	2	r	5.4
8	1	4	2	{ "e": 3, "r": 5.5 }
9	8	3	e	3
10	8	2	r	5.5)
DOTEST(-cD,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,1	0	4	\N	{ "r": [ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ], "Y": true }
2	1	5	r	[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ]
3	2	4	0	{ "e": 1, "r": 5.3 }
4	3	3	e	1
5	3	2	r	5.3
6	2	4	1	{ "e": 2, "r": 5.4 }
7	6	3	e	2
8	6	2	r	5.4
9	1	1	Y	t)
DOTEST(-cD,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,1	0	4	\N	{ "i": "II", "j": "JJ", "k": "KK", "l": "LL", "Y": "yy" }
2	1	6	i	II
3	1	6	j	JJ
4	1	6	k	KK
5	1	6	l	LL
6	1	6	Y	yy)
DOTEST(-cD,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,1	0	4	\N	{ "schedule": { "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" } }
2	1	4	schedule	{ "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" }
3	2	4	ownerLocRef	{ "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }
4	3	6	refUid	40000000-0000-0000-0000-000000000005
5	3	6	refName	System
6	3	6	refObjectType	location
7	2	5	timeCategorys	[ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ]
8	7	4	0	{ "name": "Weekdays", "colorCode": "T0" }
9	8	6	name	Weekdays
10	8	6	colorCode	T0
11	7	4	1	{ "name": "Nights and Weekends", "colorCode": "T1" }
12	11	6	name	Nights and Weekends
13	11	6	colorCode	T1
14	7	4	2	{ "name": "", "colorCode": "T2" }
15	14	6	name	
16	14	6	colorCode	T2
17	7	4	3	{ "name": "", "colorCode": "T3" }
18	17	6	name	
19	17	6	colorCode	T3
20	7	4	4	{ "name": "", "colorCode": "T4" }
21	20	6	name	
22	20	6	colorCode	T4
23	7	4	5	{ "name": "", "colorCode": "T5" }
24	23	6	name	
25	23	6	colorCode	T5
26	7	4	6	{ "name": "", "colorCode": "T6" }
27	26	6	name	
28	26	6	colorCode	T6
29	7	4	7	{ "name": "", "colorCode": "T7" }
30	29	6	name	
31	29	6	colorCode	T7
32	2	5	weeklySchedules	[ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ]
33	32	4	0	{ "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }
34	33	6	name	Weekly Schedule 1
35	33	5	dailySchedules	[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
36	35	4	0	{ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
37	36	6	dayOfWeek	MON
38	36	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
39	38	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
40	39	6	startTime	00:00:00
41	39	6	endTime	08:00:00
42	39	6	colorCode	T1
43	38	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
44	43	6	startTime	08:00:00
45	43	6	endTime	17:00:00
46	43	6	colorCode	T0
47	38	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
48	47	6	startTime	17:00:00
49	47	6	endTime	24:00:00
50	47	6	colorCode	T1
51	35	4	1	{ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
52	51	6	dayOfWeek	TUE
53	51	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
54	53	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
55	54	6	startTime	00:00:00
56	54	6	endTime	08:00:00
57	54	6	colorCode	T1
58	53	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
59	58	6	startTime	08:00:00
60	58	6	endTime	17:00:00
61	58	6	colorCode	T0
62	53	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
63	62	6	startTime	17:00:00
64	62	6	endTime	24:00:00
65	62	6	colorCode	T1
66	35	4	2	{ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
67	66	6	dayOfWeek	WED
68	66	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
69	68	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
70	69	6	startTime	00:00:00
71	69	6	endTime	08:00:00
72	69	6	colorCode	T1
73	68	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
74	73	6	startTime	08:00:00
75	73	6	endTime	17:00:00
76	73	6	colorCode	T0
77	68	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
78	77	6	startTime	17:00:00
79	77	6	endTime	24:00:00
80	77	6	colorCode	T1
81	35	4	3	{ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
82	81	6	dayOfWeek	THU
83	81	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
84	83	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
85	84	6	startTime	00:00:00
86	84	6	endTime	08:00:00
87	84	6	colorCode	T1
88	83	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
89	88	6	startTime	08:00:00
90	88	6	endTime	17:00:00
91	88	6	colorCode	T0
92	83	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
93	92	6	startTime	17:00:00
94	92	6	endTime	24:00:00
95	92	6	colorCode	T1
96	35	4	4	{ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
97	96	6	dayOfWeek	FRI
98	96	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
99	98	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
100	99	6	startTime	00:00:00
101	99	6	endTime	08:00:00
102	99	6	colorCode	T1
103	98	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
104	103	6	startTime	08:00:00
105	103	6	endTime	17:00:00
106	103	6	colorCode	T0
107	98	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
108	107	6	startTime	17:00:00
109	107	6	endTime	24:00:00
110	107	6	colorCode	T1
111	35	4	5	{ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
112	111	6	dayOfWeek	SAT
113	111	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
114	113	4	0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
115	114	6	startTime	00:00:00
116	114	6	endTime	24:00:00
117	114	6	colorCode	T1
118	35	4	6	{ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
119	118	6	dayOfWeek	SUN
120	118	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
121	120	4	0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
122	121	6	startTime	00:00:00
123	121	6	endTime	24:00:00
124	121	6	colorCode	T1
125	32	4	1	{ "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }
126	125	6	name	Weekly Schedule 2
127	125	6	startDate	07-01-2011
128	125	5	dailySchedules	[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
129	128	4	0	{ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
130	129	6	dayOfWeek	MON
131	129	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
132	131	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
133	132	6	startTime	00:00:00
134	132	6	endTime	08:00:00
135	132	6	colorCode	T1
136	131	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
137	136	6	startTime	08:00:00
138	136	6	endTime	17:00:00
139	136	6	colorCode	T0
140	131	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
141	140	6	startTime	17:00:00
142	140	6	endTime	24:00:00
143	140	6	colorCode	T1
144	128	4	1	{ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
145	144	6	dayOfWeek	TUE
146	144	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
147	146	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
148	147	6	startTime	00:00:00
149	147	6	endTime	08:00:00
150	147	6	colorCode	T1
151	146	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
152	151	6	startTime	08:00:00
153	151	6	endTime	17:00:00
154	151	6	colorCode	T0
155	146	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
156	155	6	startTime	17:00:00
157	155	6	endTime	24:00:00
158	155	6	colorCode	T1
159	128	4	2	{ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
160	159	6	dayOfWeek	WED
161	159	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
162	161	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
163	162	6	startTime	00:00:00
164	162	6	endTime	08:00:00
165	162	6	colorCode	T1
166	161	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
167	166	6	startTime	08:00:00
168	166	6	endTime	17:00:00
169	166	6	colorCode	T0
170	161	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
171	170	6	startTime	17:00:00
172	170	6	endTime	24:00:00
173	170	6	colorCode	T1
174	128	4	3	{ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
175	174	6	dayOfWeek	THU
176	174	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
177	176	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
178	177	6	startTime	00:00:00
179	177	6	endTime	08:00:00
180	177	6	colorCode	T1
181	176	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
182	181	6	startTime	08:00:00
183	181	6	endTime	17:00:00
184	181	6	colorCode	T0
185	176	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
186	185	6	startTime	17:00:00
187	185	6	endTime	24:00:00
188	185	6	colorCode	T1
189	128	4	4	{ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
190	189	6	dayOfWeek	FRI
191	189	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
192	191	4	0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
193	192	6	startTime	00:00:00
194	192	6	endTime	08:00:00
195	192	6	colorCode	T1
196	191	4	1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
197	196	6	startTime	08:00:00
198	196	6	endTime	17:00:00
199	196	6	colorCode	T0
200	191	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
201	200	6	startTime	17:00:00
202	200	6	endTime	24:00:00
203	200	6	colorCode	T1
204	128	4	5	{ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
205	204	6	dayOfWeek	SAT
206	204	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
207	206	4	0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
208	207	6	startTime	00:00:00
209	207	6	endTime	24:00:00
210	207	6	colorCode	T1
211	128	4	6	{ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
212	211	6	dayOfWeek	SUN
213	211	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
214	213	4	0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
215	214	6	startTime	00:00:00
216	214	6	endTime	24:00:00
217	214	6	colorCode	T1
218	2	5	specialDaySchedules	[ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
219	218	4	0	{ "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
220	219	6	name	Special Day 1
221	219	6	startDate	07-04-2011
222	219	6	endDate	07-04-2011
223	219	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
224	223	4	0	{ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }
225	224	6	startTime	00:00:00
226	224	6	endTime	09:00:00
227	224	6	colorCode	T1
228	223	4	1	{ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }
229	228	6	startTime	09:00:00
230	228	6	endTime	17:00:00
231	228	6	colorCode	T0
232	223	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
233	232	6	startTime	17:00:00
234	232	6	endTime	24:00:00
235	232	6	colorCode	T1
236	218	4	1	{ "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
237	236	6	name	Special Days 2 
238	236	6	startDate	12-24-2011
239	236	6	endDate	12-26-2011
240	236	5	timeSlices	[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
241	240	4	0	{ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }
242	241	6	startTime	00:00:00
243	241	6	endTime	09:00:00
244	241	6	colorCode	T1
245	240	4	1	{ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }
246	245	6	startTime	09:00:00
247	245	6	endTime	17:00:00
248	245	6	colorCode	T0
249	240	4	2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
250	249	6	startTime	17:00:00
251	249	6	endTime	24:00:00
252	249	6	colorCode	T1
253	2	6	name	Sample Schedule
254	2	6	tags	Sample Tags
255	2	6	description	Sample Description
256	2	6	objectType	vs_schedule)


echo '= 7 === -ccD'

DOTEST(-ccD,"erty"dnl
,1	6	\N	erty)
DOTEST(-ccD,1dnl
,1	3	\N	1)
DOTEST(-ccD,1.5dnl
,1	2	\N	1.5)
DOTEST(-ccD,truednl
,1	1	\N	t)
DOTEST(-ccD,falsednl
,1	1	\N	f)
DOTEST(-ccD,{"e":1}dnl
,1	4	\N	{ "e": 1 }
2	3	e	1)
DOTEST(-ccD,{"e":1,"r":5.3,"q":"tyui","t":true}dnl
,1	4	\N	{ "e": 1, "r": 5.3, "q": "tyui", "t": true }
2	3	e	1
3	2	r	5.3
4	6	q	tyui
5	1	t	t)
DOTEST(-ccD,[1,2,3,4,5,6]dnl
,1	5	\N	[ 1, 2, 3, 4, 5, 6 ]
2	3	0	1
3	3	1	2
4	3	2	3
5	3	3	4
6	3	4	5
7	3	5	6)
DOTEST(-ccD,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,1	5	\N	[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 }, { "e": 3, "r": 5.5 } ]
2	4	0	{ "e": 1, "r": 5.3 }
3	3	0.e	1
4	2	0.r	5.3
5	4	1	{ "e": 2, "r": 5.4 }
6	3	1.e	2
7	2	1.r	5.4
8	4	2	{ "e": 3, "r": 5.5 }
9	3	2.e	3
10	2	2.r	5.5)
DOTEST(-ccD,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,1	4	\N	{ "r": [ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ], "Y": true }
2	5	r	[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ]
3	4	r.0	{ "e": 1, "r": 5.3 }
4	3	r.0.e	1
5	2	r.0.r	5.3
6	4	r.1	{ "e": 2, "r": 5.4 }
7	3	r.1.e	2
8	2	r.1.r	5.4
9	1	Y	t)
DOTEST(-ccD,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,1	4	\N	{ "i": "II", "j": "JJ", "k": "KK", "l": "LL", "Y": "yy" }
2	6	i	II
3	6	j	JJ
4	6	k	KK
5	6	l	LL
6	6	Y	yy)
DOTEST(-ccD,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,1	4	\N	{ "schedule": { "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" } }
2	4	schedule	{ "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" }
3	4	schedule.ownerLocRef	{ "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }
4	6	schedule.ownerLocRef.refUid	40000000-0000-0000-0000-000000000005
5	6	schedule.ownerLocRef.refName	System
6	6	schedule.ownerLocRef.refObjectType	location
7	5	schedule.timeCategorys	[ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ]
8	4	schedule.timeCategorys.0	{ "name": "Weekdays", "colorCode": "T0" }
9	6	schedule.timeCategorys.0.name	Weekdays
10	6	schedule.timeCategorys.0.colorCode	T0
11	4	schedule.timeCategorys.1	{ "name": "Nights and Weekends", "colorCode": "T1" }
12	6	schedule.timeCategorys.1.name	Nights and Weekends
13	6	schedule.timeCategorys.1.colorCode	T1
14	4	schedule.timeCategorys.2	{ "name": "", "colorCode": "T2" }
15	6	schedule.timeCategorys.2.name	
16	6	schedule.timeCategorys.2.colorCode	T2
17	4	schedule.timeCategorys.3	{ "name": "", "colorCode": "T3" }
18	6	schedule.timeCategorys.3.name	
19	6	schedule.timeCategorys.3.colorCode	T3
20	4	schedule.timeCategorys.4	{ "name": "", "colorCode": "T4" }
21	6	schedule.timeCategorys.4.name	
22	6	schedule.timeCategorys.4.colorCode	T4
23	4	schedule.timeCategorys.5	{ "name": "", "colorCode": "T5" }
24	6	schedule.timeCategorys.5.name	
25	6	schedule.timeCategorys.5.colorCode	T5
26	4	schedule.timeCategorys.6	{ "name": "", "colorCode": "T6" }
27	6	schedule.timeCategorys.6.name	
28	6	schedule.timeCategorys.6.colorCode	T6
29	4	schedule.timeCategorys.7	{ "name": "", "colorCode": "T7" }
30	6	schedule.timeCategorys.7.name	
31	6	schedule.timeCategorys.7.colorCode	T7
32	5	schedule.weeklySchedules	[ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ]
33	4	schedule.weeklySchedules.0	{ "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }
34	6	schedule.weeklySchedules.0.name	Weekly Schedule 1
35	5	schedule.weeklySchedules.0.dailySchedules	[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
36	4	schedule.weeklySchedules.0.dailySchedules.0	{ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
37	6	schedule.weeklySchedules.0.dailySchedules.0.dayOfWeek	MON
38	5	schedule.weeklySchedules.0.dailySchedules.0.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
39	4	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
40	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.startTime	00:00:00
41	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.endTime	08:00:00
42	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.0.colorCode	T1
43	4	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
44	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.startTime	08:00:00
45	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.endTime	17:00:00
46	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.1.colorCode	T0
47	4	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
48	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.startTime	17:00:00
49	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.endTime	24:00:00
50	6	schedule.weeklySchedules.0.dailySchedules.0.timeSlices.2.colorCode	T1
51	4	schedule.weeklySchedules.0.dailySchedules.1	{ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
52	6	schedule.weeklySchedules.0.dailySchedules.1.dayOfWeek	TUE
53	5	schedule.weeklySchedules.0.dailySchedules.1.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
54	4	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
55	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.startTime	00:00:00
56	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.endTime	08:00:00
57	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.0.colorCode	T1
58	4	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
59	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.startTime	08:00:00
60	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.endTime	17:00:00
61	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.1.colorCode	T0
62	4	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
63	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.startTime	17:00:00
64	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.endTime	24:00:00
65	6	schedule.weeklySchedules.0.dailySchedules.1.timeSlices.2.colorCode	T1
66	4	schedule.weeklySchedules.0.dailySchedules.2	{ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
67	6	schedule.weeklySchedules.0.dailySchedules.2.dayOfWeek	WED
68	5	schedule.weeklySchedules.0.dailySchedules.2.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
69	4	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
70	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.startTime	00:00:00
71	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.endTime	08:00:00
72	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.0.colorCode	T1
73	4	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
74	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.startTime	08:00:00
75	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.endTime	17:00:00
76	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.1.colorCode	T0
77	4	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
78	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.startTime	17:00:00
79	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.endTime	24:00:00
80	6	schedule.weeklySchedules.0.dailySchedules.2.timeSlices.2.colorCode	T1
81	4	schedule.weeklySchedules.0.dailySchedules.3	{ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
82	6	schedule.weeklySchedules.0.dailySchedules.3.dayOfWeek	THU
83	5	schedule.weeklySchedules.0.dailySchedules.3.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
84	4	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
85	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.startTime	00:00:00
86	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.endTime	08:00:00
87	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.0.colorCode	T1
88	4	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
89	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.startTime	08:00:00
90	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.endTime	17:00:00
91	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.1.colorCode	T0
92	4	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
93	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.startTime	17:00:00
94	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.endTime	24:00:00
95	6	schedule.weeklySchedules.0.dailySchedules.3.timeSlices.2.colorCode	T1
96	4	schedule.weeklySchedules.0.dailySchedules.4	{ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
97	6	schedule.weeklySchedules.0.dailySchedules.4.dayOfWeek	FRI
98	5	schedule.weeklySchedules.0.dailySchedules.4.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
99	4	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
100	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.startTime	00:00:00
101	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.endTime	08:00:00
102	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.0.colorCode	T1
103	4	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
104	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.startTime	08:00:00
105	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.endTime	17:00:00
106	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.1.colorCode	T0
107	4	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
108	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.startTime	17:00:00
109	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.endTime	24:00:00
110	6	schedule.weeklySchedules.0.dailySchedules.4.timeSlices.2.colorCode	T1
111	4	schedule.weeklySchedules.0.dailySchedules.5	{ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
112	6	schedule.weeklySchedules.0.dailySchedules.5.dayOfWeek	SAT
113	5	schedule.weeklySchedules.0.dailySchedules.5.timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
114	4	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
115	6	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.startTime	00:00:00
116	6	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.endTime	24:00:00
117	6	schedule.weeklySchedules.0.dailySchedules.5.timeSlices.0.colorCode	T1
118	4	schedule.weeklySchedules.0.dailySchedules.6	{ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
119	6	schedule.weeklySchedules.0.dailySchedules.6.dayOfWeek	SUN
120	5	schedule.weeklySchedules.0.dailySchedules.6.timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
121	4	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
122	6	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.startTime	00:00:00
123	6	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.endTime	24:00:00
124	6	schedule.weeklySchedules.0.dailySchedules.6.timeSlices.0.colorCode	T1
125	4	schedule.weeklySchedules.1	{ "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }
126	6	schedule.weeklySchedules.1.name	Weekly Schedule 2
127	6	schedule.weeklySchedules.1.startDate	07-01-2011
128	5	schedule.weeklySchedules.1.dailySchedules	[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
129	4	schedule.weeklySchedules.1.dailySchedules.0	{ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
130	6	schedule.weeklySchedules.1.dailySchedules.0.dayOfWeek	MON
131	5	schedule.weeklySchedules.1.dailySchedules.0.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
132	4	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
133	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.startTime	00:00:00
134	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.endTime	08:00:00
135	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.0.colorCode	T1
136	4	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
137	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.startTime	08:00:00
138	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.endTime	17:00:00
139	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.1.colorCode	T0
140	4	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
141	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.startTime	17:00:00
142	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.endTime	24:00:00
143	6	schedule.weeklySchedules.1.dailySchedules.0.timeSlices.2.colorCode	T1
144	4	schedule.weeklySchedules.1.dailySchedules.1	{ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
145	6	schedule.weeklySchedules.1.dailySchedules.1.dayOfWeek	TUE
146	5	schedule.weeklySchedules.1.dailySchedules.1.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
147	4	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
148	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.startTime	00:00:00
149	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.endTime	08:00:00
150	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.0.colorCode	T1
151	4	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
152	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.startTime	08:00:00
153	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.endTime	17:00:00
154	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.1.colorCode	T0
155	4	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
156	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.startTime	17:00:00
157	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.endTime	24:00:00
158	6	schedule.weeklySchedules.1.dailySchedules.1.timeSlices.2.colorCode	T1
159	4	schedule.weeklySchedules.1.dailySchedules.2	{ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
160	6	schedule.weeklySchedules.1.dailySchedules.2.dayOfWeek	WED
161	5	schedule.weeklySchedules.1.dailySchedules.2.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
162	4	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
163	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.startTime	00:00:00
164	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.endTime	08:00:00
165	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.0.colorCode	T1
166	4	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
167	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.startTime	08:00:00
168	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.endTime	17:00:00
169	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.1.colorCode	T0
170	4	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
171	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.startTime	17:00:00
172	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.endTime	24:00:00
173	6	schedule.weeklySchedules.1.dailySchedules.2.timeSlices.2.colorCode	T1
174	4	schedule.weeklySchedules.1.dailySchedules.3	{ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
175	6	schedule.weeklySchedules.1.dailySchedules.3.dayOfWeek	THU
176	5	schedule.weeklySchedules.1.dailySchedules.3.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
177	4	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
178	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.startTime	00:00:00
179	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.endTime	08:00:00
180	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.0.colorCode	T1
181	4	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
182	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.startTime	08:00:00
183	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.endTime	17:00:00
184	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.1.colorCode	T0
185	4	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
186	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.startTime	17:00:00
187	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.endTime	24:00:00
188	6	schedule.weeklySchedules.1.dailySchedules.3.timeSlices.2.colorCode	T1
189	4	schedule.weeklySchedules.1.dailySchedules.4	{ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
190	6	schedule.weeklySchedules.1.dailySchedules.4.dayOfWeek	FRI
191	5	schedule.weeklySchedules.1.dailySchedules.4.timeSlices	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
192	4	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
193	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.startTime	00:00:00
194	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.endTime	08:00:00
195	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.0.colorCode	T1
196	4	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
197	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.startTime	08:00:00
198	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.endTime	17:00:00
199	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.1.colorCode	T0
200	4	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
201	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.startTime	17:00:00
202	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.endTime	24:00:00
203	6	schedule.weeklySchedules.1.dailySchedules.4.timeSlices.2.colorCode	T1
204	4	schedule.weeklySchedules.1.dailySchedules.5	{ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
205	6	schedule.weeklySchedules.1.dailySchedules.5.dayOfWeek	SAT
206	5	schedule.weeklySchedules.1.dailySchedules.5.timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
207	4	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
208	6	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.startTime	00:00:00
209	6	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.endTime	24:00:00
210	6	schedule.weeklySchedules.1.dailySchedules.5.timeSlices.0.colorCode	T1
211	4	schedule.weeklySchedules.1.dailySchedules.6	{ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
212	6	schedule.weeklySchedules.1.dailySchedules.6.dayOfWeek	SUN
213	5	schedule.weeklySchedules.1.dailySchedules.6.timeSlices	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
214	4	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
215	6	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.startTime	00:00:00
216	6	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.endTime	24:00:00
217	6	schedule.weeklySchedules.1.dailySchedules.6.timeSlices.0.colorCode	T1
218	5	schedule.specialDaySchedules	[ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
219	4	schedule.specialDaySchedules.0	{ "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
220	6	schedule.specialDaySchedules.0.name	Special Day 1
221	6	schedule.specialDaySchedules.0.startDate	07-04-2011
222	6	schedule.specialDaySchedules.0.endDate	07-04-2011
223	5	schedule.specialDaySchedules.0.timeSlices	[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
224	4	schedule.specialDaySchedules.0.timeSlices.0	{ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }
225	6	schedule.specialDaySchedules.0.timeSlices.0.startTime	00:00:00
226	6	schedule.specialDaySchedules.0.timeSlices.0.endTime	09:00:00
227	6	schedule.specialDaySchedules.0.timeSlices.0.colorCode	T1
228	4	schedule.specialDaySchedules.0.timeSlices.1	{ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }
229	6	schedule.specialDaySchedules.0.timeSlices.1.startTime	09:00:00
230	6	schedule.specialDaySchedules.0.timeSlices.1.endTime	17:00:00
231	6	schedule.specialDaySchedules.0.timeSlices.1.colorCode	T0
232	4	schedule.specialDaySchedules.0.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
233	6	schedule.specialDaySchedules.0.timeSlices.2.startTime	17:00:00
234	6	schedule.specialDaySchedules.0.timeSlices.2.endTime	24:00:00
235	6	schedule.specialDaySchedules.0.timeSlices.2.colorCode	T1
236	4	schedule.specialDaySchedules.1	{ "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
237	6	schedule.specialDaySchedules.1.name	Special Days 2 
238	6	schedule.specialDaySchedules.1.startDate	12-24-2011
239	6	schedule.specialDaySchedules.1.endDate	12-26-2011
240	5	schedule.specialDaySchedules.1.timeSlices	[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
241	4	schedule.specialDaySchedules.1.timeSlices.0	{ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }
242	6	schedule.specialDaySchedules.1.timeSlices.0.startTime	00:00:00
243	6	schedule.specialDaySchedules.1.timeSlices.0.endTime	09:00:00
244	6	schedule.specialDaySchedules.1.timeSlices.0.colorCode	T1
245	4	schedule.specialDaySchedules.1.timeSlices.1	{ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }
246	6	schedule.specialDaySchedules.1.timeSlices.1.startTime	09:00:00
247	6	schedule.specialDaySchedules.1.timeSlices.1.endTime	17:00:00
248	6	schedule.specialDaySchedules.1.timeSlices.1.colorCode	T0
249	4	schedule.specialDaySchedules.1.timeSlices.2	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
250	6	schedule.specialDaySchedules.1.timeSlices.2.startTime	17:00:00
251	6	schedule.specialDaySchedules.1.timeSlices.2.endTime	24:00:00
252	6	schedule.specialDaySchedules.1.timeSlices.2.colorCode	T1
253	6	schedule.name	Sample Schedule
254	6	schedule.tags	Sample Tags
255	6	schedule.description	Sample Description
256	6	schedule.objectType	vs_schedule)


echo '= 8 === -cccD'

DOTEST(-cccD,"erty"dnl
,1	6	\N	erty)
DOTEST(-cccD,1dnl
,1	3	\N	1)
DOTEST(-cccD,1.5dnl
,1	2	\N	1.5)
DOTEST(-cccD,truednl
,1	1	\N	t)
DOTEST(-cccD,falsednl
,1	1	\N	f)
DOTEST(-cccD,{"e":1}dnl
,1	4	\N	{ "e": 1 }
2	3	{"e"}	1)
DOTEST(-cccD,{"e":1,"r":5.3,"q":"tyui","t":true}dnl
,1	4	\N	{ "e": 1, "r": 5.3, "q": "tyui", "t": true }
2	3	{"e"}	1
3	2	{"r"}	5.3
4	6	{"q"}	tyui
5	1	{"t"}	t)
DOTEST(-cccD,[1,2,3,4,5,6]dnl
,1	5	\N	[ 1, 2, 3, 4, 5, 6 ]
2	3	{"0"}	1
3	3	{"1"}	2
4	3	{"2"}	3
5	3	{"3"}	4
6	3	{"4"}	5
7	3	{"5"}	6)
DOTEST(-cccD,[{"e":1,"r":5.3},{"e":2,"r":5.4},{"e":3,"r":5.5}]dnl
,1	5	\N	[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 }, { "e": 3, "r": 5.5 } ]
2	4	{"0"}	{ "e": 1, "r": 5.3 }
3	3	{"0","e"}	1
4	2	{"0","r"}	5.3
5	4	{"1"}	{ "e": 2, "r": 5.4 }
6	3	{"1","e"}	2
7	2	{"1","r"}	5.4
8	4	{"2"}	{ "e": 3, "r": 5.5 }
9	3	{"2","e"}	3
10	2	{"2","r"}	5.5)
DOTEST(-cccD,{"r":[{"e":1,"r":5.3},{"e":2,"r":5.4}],"Y":true}dnl
,1	4	\N	{ "r": [ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ], "Y": true }
2	5	{"r"}	[ { "e": 1, "r": 5.3 }, { "e": 2, "r": 5.4 } ]
3	4	{"r","0"}	{ "e": 1, "r": 5.3 }
4	3	{"r","0","e"}	1
5	2	{"r","0","r"}	5.3
6	4	{"r","1"}	{ "e": 2, "r": 5.4 }
7	3	{"r","1","e"}	2
8	2	{"r","1","r"}	5.4
9	1	{"Y"}	t)
DOTEST(-cccD,{"i":"II","j":"JJ","k":"KK","l":"LL","Y":"yy"}dnl
,1	4	\N	{ "i": "II", "j": "JJ", "k": "KK", "l": "LL", "Y": "yy" }
2	6	{"i"}	II
3	6	{"j"}	JJ
4	6	{"k"}	KK
5	6	{"l"}	LL
6	6	{"Y"}	yy)
DOTEST(-cccD,{"schedule":{"ownerLocRef":{"refUid":"40000000-0000-0000-0000-000000000005","refName":"System","refObjectType":"location"},"timeCategorys":[{"name":"Weekdays","colorCode":"T0"},{"name":"Nights and Weekends","colorCode":"T1"},{"name":"","colorCode":"T2"},{"name":"","colorCode":"T3"},{"name":"","colorCode":"T4"},{"name":"","colorCode":"T5"},{"name":"","colorCode":"T6"},{"name":"","colorCode":"T7"}],"weeklySchedules":[{"name":"Weekly Schedule 1","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]},{"name":"Weekly Schedule 2","startDate":"07-01-2011","dailySchedules":[{"dayOfWeek":"MON","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"TUE","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"WED","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"THU","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"FRI","timeSlices":[{"startTime":"00:00:00","endTime":"08:00:00","colorCode":"T1"},{"startTime":"08:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SAT","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"dayOfWeek":"SUN","timeSlices":[{"startTime":"00:00:00","endTime":"24:00:00","colorCode":"T1"}]}]}],"specialDaySchedules":[{"name":"Special Day 1","startDate":"07-04-2011","endDate":"07-04-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]},{"name":"Special Days 2 ","startDate":"12-24-2011","endDate":"12-26-2011","timeSlices":[{"startTime":"00:00:00","endTime":"09:00:00","colorCode":"T1"},{"startTime":"09:00:00","endTime":"17:00:00","colorCode":"T0"},{"startTime":"17:00:00","endTime":"24:00:00","colorCode":"T1"}]}],"name":"Sample Schedule","tags":"Sample Tags","description":"Sample Description","objectType":"vs_schedule"}}dnl
,1	4	\N	{ "schedule": { "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" } }
2	4	{"schedule"}	{ "ownerLocRef": { "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }, "timeCategorys": [ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ], "weeklySchedules": [ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ], "specialDaySchedules": [ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ], "name": "Sample Schedule", "tags": "Sample Tags", "description": "Sample Description", "objectType": "vs_schedule" }
3	4	{"schedule","ownerLocRef"}	{ "refUid": "40000000-0000-0000-0000-000000000005", "refName": "System", "refObjectType": "location" }
4	6	{"schedule","ownerLocRef","refUid"}	40000000-0000-0000-0000-000000000005
5	6	{"schedule","ownerLocRef","refName"}	System
6	6	{"schedule","ownerLocRef","refObjectType"}	location
7	5	{"schedule","timeCategorys"}	[ { "name": "Weekdays", "colorCode": "T0" }, { "name": "Nights and Weekends", "colorCode": "T1" }, { "name": "", "colorCode": "T2" }, { "name": "", "colorCode": "T3" }, { "name": "", "colorCode": "T4" }, { "name": "", "colorCode": "T5" }, { "name": "", "colorCode": "T6" }, { "name": "", "colorCode": "T7" } ]
8	4	{"schedule","timeCategorys","0"}	{ "name": "Weekdays", "colorCode": "T0" }
9	6	{"schedule","timeCategorys","0","name"}	Weekdays
10	6	{"schedule","timeCategorys","0","colorCode"}	T0
11	4	{"schedule","timeCategorys","1"}	{ "name": "Nights and Weekends", "colorCode": "T1" }
12	6	{"schedule","timeCategorys","1","name"}	Nights and Weekends
13	6	{"schedule","timeCategorys","1","colorCode"}	T1
14	4	{"schedule","timeCategorys","2"}	{ "name": "", "colorCode": "T2" }
15	6	{"schedule","timeCategorys","2","name"}	
16	6	{"schedule","timeCategorys","2","colorCode"}	T2
17	4	{"schedule","timeCategorys","3"}	{ "name": "", "colorCode": "T3" }
18	6	{"schedule","timeCategorys","3","name"}	
19	6	{"schedule","timeCategorys","3","colorCode"}	T3
20	4	{"schedule","timeCategorys","4"}	{ "name": "", "colorCode": "T4" }
21	6	{"schedule","timeCategorys","4","name"}	
22	6	{"schedule","timeCategorys","4","colorCode"}	T4
23	4	{"schedule","timeCategorys","5"}	{ "name": "", "colorCode": "T5" }
24	6	{"schedule","timeCategorys","5","name"}	
25	6	{"schedule","timeCategorys","5","colorCode"}	T5
26	4	{"schedule","timeCategorys","6"}	{ "name": "", "colorCode": "T6" }
27	6	{"schedule","timeCategorys","6","name"}	
28	6	{"schedule","timeCategorys","6","colorCode"}	T6
29	4	{"schedule","timeCategorys","7"}	{ "name": "", "colorCode": "T7" }
30	6	{"schedule","timeCategorys","7","name"}	
31	6	{"schedule","timeCategorys","7","colorCode"}	T7
32	5	{"schedule","weeklySchedules"}	[ { "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }, { "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] } ]
33	4	{"schedule","weeklySchedules","0"}	{ "name": "Weekly Schedule 1", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }
34	6	{"schedule","weeklySchedules","0","name"}	Weekly Schedule 1
35	5	{"schedule","weeklySchedules","0","dailySchedules"}	[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
36	4	{"schedule","weeklySchedules","0","dailySchedules","0"}	{ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
37	6	{"schedule","weeklySchedules","0","dailySchedules","0","dayOfWeek"}	MON
38	5	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
39	4	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
40	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0","startTime"}	00:00:00
41	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0","endTime"}	08:00:00
42	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","0","colorCode"}	T1
43	4	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
44	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1","startTime"}	08:00:00
45	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1","endTime"}	17:00:00
46	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","1","colorCode"}	T0
47	4	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
48	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2","startTime"}	17:00:00
49	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2","endTime"}	24:00:00
50	6	{"schedule","weeklySchedules","0","dailySchedules","0","timeSlices","2","colorCode"}	T1
51	4	{"schedule","weeklySchedules","0","dailySchedules","1"}	{ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
52	6	{"schedule","weeklySchedules","0","dailySchedules","1","dayOfWeek"}	TUE
53	5	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
54	4	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
55	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0","startTime"}	00:00:00
56	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0","endTime"}	08:00:00
57	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","0","colorCode"}	T1
58	4	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
59	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1","startTime"}	08:00:00
60	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1","endTime"}	17:00:00
61	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","1","colorCode"}	T0
62	4	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
63	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2","startTime"}	17:00:00
64	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2","endTime"}	24:00:00
65	6	{"schedule","weeklySchedules","0","dailySchedules","1","timeSlices","2","colorCode"}	T1
66	4	{"schedule","weeklySchedules","0","dailySchedules","2"}	{ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
67	6	{"schedule","weeklySchedules","0","dailySchedules","2","dayOfWeek"}	WED
68	5	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
69	4	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
70	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0","startTime"}	00:00:00
71	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0","endTime"}	08:00:00
72	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","0","colorCode"}	T1
73	4	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
74	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1","startTime"}	08:00:00
75	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1","endTime"}	17:00:00
76	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","1","colorCode"}	T0
77	4	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
78	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2","startTime"}	17:00:00
79	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2","endTime"}	24:00:00
80	6	{"schedule","weeklySchedules","0","dailySchedules","2","timeSlices","2","colorCode"}	T1
81	4	{"schedule","weeklySchedules","0","dailySchedules","3"}	{ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
82	6	{"schedule","weeklySchedules","0","dailySchedules","3","dayOfWeek"}	THU
83	5	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
84	4	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
85	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0","startTime"}	00:00:00
86	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0","endTime"}	08:00:00
87	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","0","colorCode"}	T1
88	4	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
89	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1","startTime"}	08:00:00
90	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1","endTime"}	17:00:00
91	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","1","colorCode"}	T0
92	4	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
93	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2","startTime"}	17:00:00
94	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2","endTime"}	24:00:00
95	6	{"schedule","weeklySchedules","0","dailySchedules","3","timeSlices","2","colorCode"}	T1
96	4	{"schedule","weeklySchedules","0","dailySchedules","4"}	{ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
97	6	{"schedule","weeklySchedules","0","dailySchedules","4","dayOfWeek"}	FRI
98	5	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
99	4	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
100	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0","startTime"}	00:00:00
101	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0","endTime"}	08:00:00
102	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","0","colorCode"}	T1
103	4	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
104	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1","startTime"}	08:00:00
105	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1","endTime"}	17:00:00
106	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","1","colorCode"}	T0
107	4	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
108	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2","startTime"}	17:00:00
109	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2","endTime"}	24:00:00
110	6	{"schedule","weeklySchedules","0","dailySchedules","4","timeSlices","2","colorCode"}	T1
111	4	{"schedule","weeklySchedules","0","dailySchedules","5"}	{ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
112	6	{"schedule","weeklySchedules","0","dailySchedules","5","dayOfWeek"}	SAT
113	5	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
114	4	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
115	6	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0","startTime"}	00:00:00
116	6	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0","endTime"}	24:00:00
117	6	{"schedule","weeklySchedules","0","dailySchedules","5","timeSlices","0","colorCode"}	T1
118	4	{"schedule","weeklySchedules","0","dailySchedules","6"}	{ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
119	6	{"schedule","weeklySchedules","0","dailySchedules","6","dayOfWeek"}	SUN
120	5	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
121	4	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
122	6	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0","startTime"}	00:00:00
123	6	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0","endTime"}	24:00:00
124	6	{"schedule","weeklySchedules","0","dailySchedules","6","timeSlices","0","colorCode"}	T1
125	4	{"schedule","weeklySchedules","1"}	{ "name": "Weekly Schedule 2", "startDate": "07-01-2011", "dailySchedules": [ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ] }
126	6	{"schedule","weeklySchedules","1","name"}	Weekly Schedule 2
127	6	{"schedule","weeklySchedules","1","startDate"}	07-01-2011
128	5	{"schedule","weeklySchedules","1","dailySchedules"}	[ { "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
129	4	{"schedule","weeklySchedules","1","dailySchedules","0"}	{ "dayOfWeek": "MON", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
130	6	{"schedule","weeklySchedules","1","dailySchedules","0","dayOfWeek"}	MON
131	5	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
132	4	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
133	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0","startTime"}	00:00:00
134	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0","endTime"}	08:00:00
135	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","0","colorCode"}	T1
136	4	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
137	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1","startTime"}	08:00:00
138	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1","endTime"}	17:00:00
139	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","1","colorCode"}	T0
140	4	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
141	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2","startTime"}	17:00:00
142	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2","endTime"}	24:00:00
143	6	{"schedule","weeklySchedules","1","dailySchedules","0","timeSlices","2","colorCode"}	T1
144	4	{"schedule","weeklySchedules","1","dailySchedules","1"}	{ "dayOfWeek": "TUE", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
145	6	{"schedule","weeklySchedules","1","dailySchedules","1","dayOfWeek"}	TUE
146	5	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
147	4	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
148	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0","startTime"}	00:00:00
149	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0","endTime"}	08:00:00
150	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","0","colorCode"}	T1
151	4	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
152	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1","startTime"}	08:00:00
153	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1","endTime"}	17:00:00
154	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","1","colorCode"}	T0
155	4	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
156	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2","startTime"}	17:00:00
157	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2","endTime"}	24:00:00
158	6	{"schedule","weeklySchedules","1","dailySchedules","1","timeSlices","2","colorCode"}	T1
159	4	{"schedule","weeklySchedules","1","dailySchedules","2"}	{ "dayOfWeek": "WED", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
160	6	{"schedule","weeklySchedules","1","dailySchedules","2","dayOfWeek"}	WED
161	5	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
162	4	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
163	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0","startTime"}	00:00:00
164	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0","endTime"}	08:00:00
165	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","0","colorCode"}	T1
166	4	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
167	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1","startTime"}	08:00:00
168	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1","endTime"}	17:00:00
169	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","1","colorCode"}	T0
170	4	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
171	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2","startTime"}	17:00:00
172	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2","endTime"}	24:00:00
173	6	{"schedule","weeklySchedules","1","dailySchedules","2","timeSlices","2","colorCode"}	T1
174	4	{"schedule","weeklySchedules","1","dailySchedules","3"}	{ "dayOfWeek": "THU", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
175	6	{"schedule","weeklySchedules","1","dailySchedules","3","dayOfWeek"}	THU
176	5	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
177	4	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
178	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0","startTime"}	00:00:00
179	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0","endTime"}	08:00:00
180	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","0","colorCode"}	T1
181	4	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
182	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1","startTime"}	08:00:00
183	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1","endTime"}	17:00:00
184	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","1","colorCode"}	T0
185	4	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
186	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2","startTime"}	17:00:00
187	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2","endTime"}	24:00:00
188	6	{"schedule","weeklySchedules","1","dailySchedules","3","timeSlices","2","colorCode"}	T1
189	4	{"schedule","weeklySchedules","1","dailySchedules","4"}	{ "dayOfWeek": "FRI", "timeSlices": [ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
190	6	{"schedule","weeklySchedules","1","dailySchedules","4","dayOfWeek"}	FRI
191	5	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }, { "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
192	4	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "08:00:00", "colorCode": "T1" }
193	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0","startTime"}	00:00:00
194	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0","endTime"}	08:00:00
195	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","0","colorCode"}	T1
196	4	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1"}	{ "startTime": "08:00:00", "endTime": "17:00:00", "colorCode": "T0" }
197	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1","startTime"}	08:00:00
198	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1","endTime"}	17:00:00
199	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","1","colorCode"}	T0
200	4	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
201	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2","startTime"}	17:00:00
202	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2","endTime"}	24:00:00
203	6	{"schedule","weeklySchedules","1","dailySchedules","4","timeSlices","2","colorCode"}	T1
204	4	{"schedule","weeklySchedules","1","dailySchedules","5"}	{ "dayOfWeek": "SAT", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
205	6	{"schedule","weeklySchedules","1","dailySchedules","5","dayOfWeek"}	SAT
206	5	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
207	4	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
208	6	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0","startTime"}	00:00:00
209	6	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0","endTime"}	24:00:00
210	6	{"schedule","weeklySchedules","1","dailySchedules","5","timeSlices","0","colorCode"}	T1
211	4	{"schedule","weeklySchedules","1","dailySchedules","6"}	{ "dayOfWeek": "SUN", "timeSlices": [ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
212	6	{"schedule","weeklySchedules","1","dailySchedules","6","dayOfWeek"}	SUN
213	5	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
214	4	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "24:00:00", "colorCode": "T1" }
215	6	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0","startTime"}	00:00:00
216	6	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0","endTime"}	24:00:00
217	6	{"schedule","weeklySchedules","1","dailySchedules","6","timeSlices","0","colorCode"}	T1
218	5	{"schedule","specialDaySchedules"}	[ { "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }, { "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] } ]
219	4	{"schedule","specialDaySchedules","0"}	{ "name": "Special Day 1", "startDate": "07-04-2011", "endDate": "07-04-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
220	6	{"schedule","specialDaySchedules","0","name"}	Special Day 1
221	6	{"schedule","specialDaySchedules","0","startDate"}	07-04-2011
222	6	{"schedule","specialDaySchedules","0","endDate"}	07-04-2011
223	5	{"schedule","specialDaySchedules","0","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
224	4	{"schedule","specialDaySchedules","0","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }
225	6	{"schedule","specialDaySchedules","0","timeSlices","0","startTime"}	00:00:00
226	6	{"schedule","specialDaySchedules","0","timeSlices","0","endTime"}	09:00:00
227	6	{"schedule","specialDaySchedules","0","timeSlices","0","colorCode"}	T1
228	4	{"schedule","specialDaySchedules","0","timeSlices","1"}	{ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }
229	6	{"schedule","specialDaySchedules","0","timeSlices","1","startTime"}	09:00:00
230	6	{"schedule","specialDaySchedules","0","timeSlices","1","endTime"}	17:00:00
231	6	{"schedule","specialDaySchedules","0","timeSlices","1","colorCode"}	T0
232	4	{"schedule","specialDaySchedules","0","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
233	6	{"schedule","specialDaySchedules","0","timeSlices","2","startTime"}	17:00:00
234	6	{"schedule","specialDaySchedules","0","timeSlices","2","endTime"}	24:00:00
235	6	{"schedule","specialDaySchedules","0","timeSlices","2","colorCode"}	T1
236	4	{"schedule","specialDaySchedules","1"}	{ "name": "Special Days 2 ", "startDate": "12-24-2011", "endDate": "12-26-2011", "timeSlices": [ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ] }
237	6	{"schedule","specialDaySchedules","1","name"}	Special Days 2 
238	6	{"schedule","specialDaySchedules","1","startDate"}	12-24-2011
239	6	{"schedule","specialDaySchedules","1","endDate"}	12-26-2011
240	5	{"schedule","specialDaySchedules","1","timeSlices"}	[ { "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }, { "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }, { "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" } ]
241	4	{"schedule","specialDaySchedules","1","timeSlices","0"}	{ "startTime": "00:00:00", "endTime": "09:00:00", "colorCode": "T1" }
242	6	{"schedule","specialDaySchedules","1","timeSlices","0","startTime"}	00:00:00
243	6	{"schedule","specialDaySchedules","1","timeSlices","0","endTime"}	09:00:00
244	6	{"schedule","specialDaySchedules","1","timeSlices","0","colorCode"}	T1
245	4	{"schedule","specialDaySchedules","1","timeSlices","1"}	{ "startTime": "09:00:00", "endTime": "17:00:00", "colorCode": "T0" }
246	6	{"schedule","specialDaySchedules","1","timeSlices","1","startTime"}	09:00:00
247	6	{"schedule","specialDaySchedules","1","timeSlices","1","endTime"}	17:00:00
248	6	{"schedule","specialDaySchedules","1","timeSlices","1","colorCode"}	T0
249	4	{"schedule","specialDaySchedules","1","timeSlices","2"}	{ "startTime": "17:00:00", "endTime": "24:00:00", "colorCode": "T1" }
250	6	{"schedule","specialDaySchedules","1","timeSlices","2","startTime"}	17:00:00
251	6	{"schedule","specialDaySchedules","1","timeSlices","2","endTime"}	24:00:00
252	6	{"schedule","specialDaySchedules","1","timeSlices","2","colorCode"}	T1
253	6	{"schedule","name"}	Sample Schedule
254	6	{"schedule","tags"}	Sample Tags
255	6	{"schedule","description"}	Sample Description
256	6	{"schedule","objectType"}	vs_schedule)


echo '= 8 === -a...'

DOTEST(-aD,"erty"1 1.5true{"e":1}
,string  =erty~
int     =1
double  =1.5
boolean =1
int     e=1)

DOTEST(-aDD,"erty"1 1.5true{"e":1}
,string  =erty~
int     =1
double  =1.5
boolean =1
object  
int     e=1)

DOTEST(-aDDD,"erty"1 1.5true{"e":1}
,string  =erty~
int     =1
double  =1.5
boolean =1
object  ={ "e": 1 }~
int     e=1)

DOTEST(-ac,"erty"1 1.5true{"e":1}
,1	0	6	\N	erty
2	0	3	\N	1
3	0	2	\N	1.5
4	0	1	\N	t
5	0	4	\N	\N
6	5	3	e	1)

DOTEST(-acc,"erty"1 1.5true{"e":1}
,1	6	\N	erty
2	3	\N	1
3	2	\N	1.5
4	1	\N	t
5	4	\N	\N
6	3	e	1)

DOTEST(-accc,"erty"1 1.5true{"e":1}
,1	6	\N	erty
2	3	\N	1
3	2	\N	1.5
4	1	\N	t
5	4	\N	\N
6	3	{"e"}	1)

DOTEST(-acD,"erty"1 1.5true{"e":1}
,1	0	6	\N	erty
2	0	3	\N	1
3	0	2	\N	1.5
4	0	1	\N	t
5	0	4	\N	{ "e": 1 }
6	5	3	e	1)

DOTEST(-acDD,"erty"1 1.5true{"e":1}
,1	0	6	\N	erty
2	0	3	\N	1
3	0	2	\N	1.5
4	0	1	\N	t
5	0	4	\N	{ "e": 1 }
6	5	3	e	1)

DOTEST(-accD,"erty"1 1.5true{"e":1}
,1	6	\N	erty
2	3	\N	1
3	2	\N	1.5
4	1	\N	t
5	4	\N	{ "e": 1 }
6	3	e	1)

DOTEST(-accDD,"erty"1 1.5true{"e":1}
,1	6	\N	erty
2	3	\N	1
3	2	\N	1.5
4	1	\N	t
5	4	\N	{ "e": 1 }
6	3	e	1)

DOTEST(-acccD,"erty"1 1.5true{"e":1}
,1	6	\N	erty
2	3	\N	1
3	2	\N	1.5
4	1	\N	t
5	4	\N	{ "e": 1 }
6	3	{"e"}	1)

DOTEST(-acccDD,"erty"1 1.5true{"e":1}
,1	6	\N	erty
2	3	\N	1
3	2	\N	1.5
4	1	\N	t
5	4	\N	{ "e": 1 }
6	3	{"e"}	1)

echo '= 9 === -b...'

DOTEST(-bdata.result -imetric.enum -ivalue.0 -ivalue.1,{"status":"success","data":{"resultType":"vector","result":[{"metric":{},"value":[1704404743,"1"]},{"metric":{"enum":"0805307179"},"value":[1704404743,"19.25"]},{"metric":{"enum":"1743013019"},"value":[1704404743,"17"]}]},"stats":{"seriesFetched":"320764"}}
,\N	1704404743	1
0805307179	1704404743	19.25
1743013019	1704404743	17)

DOTEST(-nbdata.result -imetric.enum -ivalue.0 -ivalue.1,{"status":"success","data":{"resultType":"vector","result":[{"metric":{},"value":[1704404743,"1"]},{"metric":{"enum":"0805307179"},"value":[1704404743,"19.25"]},{"metric":{"enum":"1743013019"},"value":[1704404743,"17"]}]},"stats":{"seriesFetched":"320764"}}
,0	\N	1704404743	1
1	0805307179	1704404743	19.25
2	1743013019	1704404743	17)

DOTEST(-nbdata.result,{"status":"success","data":{"resultType":"vector","result":[{"metric":{},"value":[1704404743,"1"]},{"metric":{"enum":"0805307179"},"value":[1704404743,"19.25"]},{"metric":{"enum":"1743013019"},"value":[1704404743,"17"]}]},"stats":{"seriesFetched":"320764"}}
,0
1
2)

DOTEST(-bdata.result,{"status":"success","data":{"resultType":"vector","result":[{"metric":{},"value":[1704404743,"1"]},{"metric":{"enum":"0805307179"},"value":[1704404743,"19.25"]},{"metric":{"enum":"1743013019"},"value":[1704404743,"17"]}]},"stats":{"seriesFetched":"320764"}}
,

)

dnl DOTEST(,,)
rm -f ${TI} ${TO}
echo "${e} errors"
