#!BINDIR/pgoblin -f
  Copyright (C)2019..2022 @BABOLO http://www.babolo.ru/
--pkg = PKG
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $Id: version.pgoblin.m4,v 1.9 2022/04/30 03:05:44 babolo Exp $

#perform 0002  ########################################        ####
CREATE TABLE IF NOT EXISTS public.version
     ( pkg      text NOT NULL
     , protover text
     , major    int  NOT NULL
     , minor    text NOT NULL
     , comconf  bool
     , UNIQUE(pkg, protover)
     )
;
#perform 0002
CREATE UNIQUE INDEX IF NOT EXISTS version_p ON public.version(pkg) WHERE protover IS NULL;
#perform 0002
GRANT ALL ON public.version TO operator, PROTOVER;
#perform 0002
COMMENT ON TABLE public.version        IS '     ';
COMMENT ON COLUMN public.version.pkg      IS ' ';
COMMENT ON COLUMN public.version.protover IS ' ';
COMMENT ON COLUMN public.version.major    IS ' ';
COMMENT ON COLUMN public.version.minor    IS ' ';
COMMENT ON COLUMN public.version.comconf  IS ' ';
#perform 0002  ################################################################     ####
CREATE TABLE IF NOT EXISTS public.srcs
     ( pkg      text NOT NULL
     , major    int  NOT NULL
     , minor    text NOT NULL
     , PRIMARY KEY(pkg, major)
     )
;
#perform 0002
GRANT ALL ON public.srcs TO operator, PROTOVER;
#perform 0002
GRANT SELECT ON public.srcs TO public;
#perform 0002
COMMENT ON TABLE public.srcs        IS '  ';
COMMENT ON COLUMN public.srcs.pkg      IS ' ';
COMMENT ON COLUMN public.srcs.major    IS ' ';
COMMENT ON COLUMN public.srcs.minor    IS ' ';
#select  1001  ###########################################################################    ####
SELECT 'DROP VIEW IF EXISTS public.babolover;
'FROM v
 WHERE v.v < '2.06'
;
#perform 0102
#perform 0002
CREATE OR REPLACE VIEW public.babolover AS
 SELECT pkg
      , protover
      , s.major     AS smj
      , s.minor      AS smi
      , version.major AS vmj
      , version.minor AS vmi
      , comconf
  FROM       (SELECT DISTINCT ON(pkg) pkg, major, minor
               FROM public.srcs
              ORDER BY pkg, major DESC, minor DESC
             )s
   FULL JOIN public.version USING(pkg)
;
#perform 0002
GRANT SELECT ON public.babolover TO public;
#perform 0002
COMMENT ON VIEW public.babolover         IS ' ';
COMMENT ON COLUMN public.babolover.pkg      IS ' ';
COMMENT ON COLUMN public.babolover.protover IS ' ';
COMMENT ON COLUMN public.babolover.smj      IS '  ';
COMMENT ON COLUMN public.babolover.smi      IS '  ';
COMMENT ON COLUMN public.babolover.vmj      IS '  ';
COMMENT ON COLUMN public.babolover.vmi      IS '  ';
#perform 0002  ######################################################       ####
CREATE TABLE IF NOT EXISTS public.cipaver
     ( pkg      text NOT NULL
     , protover text
     , major    int  NOT NULL
     , minor    text NOT NULL
     , UNIQUE(pkg, protover)
     )
;
#perform 0002
CREATE UNIQUE INDEX IF NOT EXISTS cipaver_p ON public.cipaver(pkg) WHERE protover IS NULL;
#perform 0002
GRANT ALL ON public.cipaver TO operator, PROTOVER;
#perform 0002
COMMENT ON TABLE public.cipaver        IS '    ';
COMMENT ON COLUMN public.cipaver.pkg      IS ' ';
COMMENT ON COLUMN public.cipaver.protover IS ' ';
COMMENT ON COLUMN public.cipaver.major    IS ' ';
COMMENT ON COLUMN public.cipaver.minor    IS ' ';
#perform 0002
CREATE OR REPLACE FUNCTION public.cipaover(pkg text, protover text, major int, minor text)
 RETURNS void
 AS 'WITH d AS(UPDATE public.cipaver
                  SET major = $3, minor = $4
                WHERE cipaver.protover IS NOT DISTINCT FROM $2
                  AND cipaver.pkg = $1
               RETURNING 1
              )
     INSERT INTO public.cipaver
      SELECT $1, $2, $3, $4
       WHERE NOT EXISTS(SELECT 1 FROM d)
    '
 VOLATILE LANGUAGE SQL
;
#perform 0002
COMMENT ON FUNCTION public.cipaover(pkg text, protover text, major int, minor text)
 IS ' '
;
#
